/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.pixies.companions;

import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerCompanions;
import com.verdantartifice.primalmagick.common.entities.ai.goals.FollowCompanionOwnerGoal;
import com.verdantartifice.primalmagick.common.entities.companions.AbstractCompanionEntity;
import com.verdantartifice.primalmagick.common.entities.companions.CompanionManager;
import com.verdantartifice.primalmagick.common.entities.pixies.IPixie;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellPropertiesPM;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.spells.vehicles.BoltSpellVehicle;
import java.util.EnumSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractPixieEntity
extends AbstractCompanionEntity
implements NeutralMob,
FlyingAnimal,
IPixie {
    protected static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.defineId(AbstractPixieEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final UniformInt ANGER_TIME_RANGE = TimeUtil.rangeOfSeconds((int)20, (int)39);
    protected static final byte PIXIE_DUST_EVENT = 15;
    protected int attackTimer;
    protected UUID angerTarget;
    protected SpellPackage spellCache;

    public AbstractPixieEntity(EntityType<? extends AbstractPixieEntity> type, Level worldIn) {
        super(type, worldIn);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, false);
    }

    @Override
    @Nonnull
    public abstract Source getPixieSource();

    @Nonnull
    protected abstract SpawnEggItem getSpawnItem();

    @Nonnull
    protected SpellPackage createSpellPackage() {
        return SpellPackage.builder().name("Pixie Bolt").vehicle().type(BoltSpellVehicle.INSTANCE).with(SpellPropertiesPM.RANGE.get(), 5).end().payload().type(this.getSpellPayload()).with(SpellPropertiesPM.POWER.get(), this.getSpellPower()).with(SpellPropertiesPM.DURATION.get(), this.getSpellPower()).end().build();
    }

    @Nonnull
    protected abstract AbstractSpellPayload<?> getSpellPayload();

    @Nonnull
    protected SpellPackage getSpellPackage() {
        if (this.spellCache == null) {
            this.spellCache = this.createSpellPackage();
        }
        return this.spellCache;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.addPersistentAngerSaveData(compound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        Level level = this.level();
        if (!level.isClientSide) {
            this.readPersistentAngerSaveData((Level)((ServerLevel)level), compound);
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(5, (Goal)new FollowCompanionOwnerGoal(this, 1.0, 5.0f, 1.0f, true));
        this.goalSelector.addGoal(6, (Goal)new RandomFlyGoal(this, 16.0f));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(ANGER_TIME, (Object)0);
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public int getAmbientSoundInterval() {
        return 120;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void aiStep() {
        super.aiStep();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        Level level = this.level();
        if (!level.isClientSide) {
            this.updatePersistentAnger((ServerLevel)level, true);
            if (this.isAlive()) {
                level.broadcastEntityEvent((Entity)this, (byte)15);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
    }

    public void handleEntityEvent(byte id) {
        if (id == 15) {
            FxDispatcher.INSTANCE.pixieDust(this.getX() + this.random.nextGaussian() * 0.25, this.getY() + 0.25, this.getZ() + this.random.nextGaussian() * 0.25, this.getPixieSource().getColor());
        } else {
            super.handleEntityEvent(id);
        }
    }

    public boolean canAttack(LivingEntity target) {
        return this.isCompanionOwner(target) ? false : super.canAttack(target);
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.entityData.set(ANGER_TIME, (Object)time);
    }

    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }

    public void setPersistentAngerTarget(UUID target) {
        this.angerTarget = target;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_TIME_RANGE.sample(this.random));
    }

    @Override
    public IPlayerCompanions.CompanionType getCompanionType() {
        return IPlayerCompanions.CompanionType.PIXIE;
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.BAT_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.BAT_DEATH;
    }

    protected InteractionResult mobInteract(Player playerIn, InteractionHand hand) {
        Level level = this.level();
        InteractionResult actionResult = super.mobInteract(playerIn, hand);
        if (!actionResult.consumesAction() && !level.isClientSide && this.isCompanionOwner((LivingEntity)playerIn)) {
            ItemStack stack;
            ItemStack held = playerIn.getItemInHand(hand);
            if (ItemStack.isSameItem((ItemStack)held, (ItemStack)(stack = new ItemStack((ItemLike)this.getSpawnItem())))) {
                held.grow(1);
            } else if (held.isEmpty()) {
                playerIn.setItemInHand(hand, stack);
            } else {
                return InteractionResult.FAIL;
            }
            CompanionManager.removeCompanion(this.getCompanionOwner(), this);
            this.playSound(this.getHurtSound(null), 1.0f, 1.0f);
            this.discard();
            return InteractionResult.SUCCESS;
        }
        return actionResult;
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity entityIn) {
    }

    protected void pushEntities() {
    }

    public boolean canBeLeashed() {
        return false;
    }

    protected PathNavigation createNavigation(Level worldIn) {
        FlyingPathNavigation nav = new FlyingPathNavigation((Mob)this, worldIn);
        nav.setCanOpenDoors(false);
        nav.setCanPassDoors(true);
        return nav;
    }

    protected static class RandomFlyGoal
    extends Goal {
        protected final AbstractPixieEntity pixie;
        protected final PathNavigation navigator;
        protected final float wanderDistance;
        protected int timeToRecalcPath;

        public RandomFlyGoal(AbstractPixieEntity pixie, float wanderDistance) {
            this.pixie = pixie;
            this.navigator = this.pixie.getNavigation();
            this.wanderDistance = wanderDistance;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            double dz;
            double dy;
            MoveControl movementcontroller = this.pixie.getMoveControl();
            if (!movementcontroller.hasWanted()) {
                return true;
            }
            double dx = movementcontroller.getWantedX() - this.pixie.getX();
            double dist = dx * dx + (dy = movementcontroller.getWantedY() - this.pixie.getY()) * dy + (dz = movementcontroller.getWantedZ() - this.pixie.getZ()) * dz;
            return dist < 1.0 || dist > 3600.0;
        }

        public boolean canContinueToUse() {
            return this.timeToRecalcPath > 0;
        }

        public void start() {
            this.timeToRecalcPath = 0;
        }

        public void tick() {
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 40;
                RandomSource random = this.pixie.getRandom();
                double d0 = this.pixie.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * this.wanderDistance);
                double d1 = this.pixie.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 2.0f);
                double d2 = this.pixie.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * this.wanderDistance);
                this.navigator.moveTo(d0, d1, d2, 1.0);
            }
        }
    }
}

