/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.pixies.companions;

import com.verdantartifice.primalmagick.common.entities.ai.goals.CompanionOwnerHurtByTargetGoal;
import com.verdantartifice.primalmagick.common.entities.ai.goals.CompanionOwnerHurtTargetGoal;
import com.verdantartifice.primalmagick.common.entities.ai.goals.ZoomAtTargetGoal;
import com.verdantartifice.primalmagick.common.entities.pixies.companions.AbstractPixieEntity;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.spells.payloads.AbstractSpellPayload;
import com.verdantartifice.primalmagick.common.spells.payloads.FlameDamageSpellPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;

public abstract class AbstractInfernalPixieEntity
extends AbstractPixieEntity {
    public AbstractInfernalPixieEntity(EntityType<? extends AbstractPixieEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public Source getPixieSource() {
        return Sources.INFERNAL;
    }

    @Override
    protected AbstractSpellPayload<?> getSpellPayload() {
        return FlameDamageSpellPayload.INSTANCE;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new ExplodeOnTargetGoal(this, 1.0f));
        this.goalSelector.addGoal(3, (Goal)new ZoomAtTargetGoal((Mob)this, 2.0f, 8.0f, 0.4f));
        this.goalSelector.addGoal(4, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 32.0f));
        this.targetSelector.addGoal(1, (Goal)new CompanionOwnerHurtByTargetGoal(this));
        this.targetSelector.addGoal(2, (Goal)new CompanionOwnerHurtTargetGoal(this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((AbstractInfernalPixieEntity)this).isAngryAt(arg_0)));
    }

    public void explode() {
        Level level = this.level();
        if (!level.isClientSide) {
            Explosion explosion = level.explode((Entity)this, this.getX(), this.getY(), this.getZ(), (float)this.getSpellPower(), true, Level.ExplosionInteraction.TNT);
            this.hurt(this.level().damageSources().explosion(explosion), Float.MAX_VALUE);
        }
    }

    public static class ExplodeOnTargetGoal
    extends Goal {
        protected final AbstractInfernalPixieEntity pixie;
        protected final float maxRangeSq;

        public ExplodeOnTargetGoal(AbstractInfernalPixieEntity pixie, float maxRange) {
            this.pixie = pixie;
            this.maxRangeSq = maxRange * maxRange;
        }

        public boolean canUse() {
            LivingEntity target = this.pixie.getTarget();
            return target != null && this.pixie.distanceToSqr((Entity)target) <= (double)this.maxRangeSq;
        }

        public void start() {
            this.pixie.explode();
        }
    }
}

