/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.misc;

import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.entities.misc.InnerDemonEntity;
import com.verdantartifice.primalmagick.common.util.EntityUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class SinCrystalEntity
extends Entity {
    private static final EntityDataAccessor<Optional<BlockPos>> BEAM_TARGET = SynchedEntityData.defineId(SinCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Optional<UUID>> DAMAGE_CLOUD = SynchedEntityData.defineId(SinCrystalEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public int innerRotation;

    public SinCrystalEntity(EntityType<? extends SinCrystalEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.blocksBuilding = true;
        this.innerRotation = this.random.nextInt(100000);
    }

    public SinCrystalEntity(Level worldIn, double x, double y, double z) {
        this(EntityTypesPM.SIN_CRYSTAL.get(), worldIn);
        this.setPos(x, y, z);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(BEAM_TARGET, Optional.empty());
        pBuilder.define(DAMAGE_CLOUD, Optional.empty());
    }

    public void tick() {
        super.tick();
        ++this.innerRotation;
        Level level = this.level();
        if (!level.isClientSide && level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            UUID cloudId = this.getDamageCloud();
            if (cloudId == null) {
                AreaEffectCloud cloud = new AreaEffectCloud(level, this.getX(), this.getY(), this.getZ());
                cloud.setParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH);
                cloud.setRadius(3.0f);
                cloud.setDuration(5);
                cloud.setWaitTime(0);
                cloud.addEffect(new MobEffectInstance(MobEffects.HARM, 1, 1));
                level.addFreshEntity((Entity)cloud);
                this.setDamageCloud(cloud.getUUID());
            } else {
                Entity entity = serverWorld.getEntity(cloudId);
                if (entity instanceof AreaEffectCloud) {
                    AreaEffectCloud cloud = (AreaEffectCloud)entity;
                    cloud.setDuration(1 + cloud.getDuration());
                } else {
                    this.setDamageCloud(null);
                }
            }
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        NbtUtils.readBlockPos((CompoundTag)compound, (String)"BeamTarget").ifPresent(this::setBeamTarget);
        if (compound.contains("DamageCloudUUID", 10)) {
            this.setDamageCloud(compound.getUUID("DamageCloudUUID"));
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        if (this.getBeamTarget() != null) {
            compound.put("BeamTarget", NbtUtils.writeBlockPos((BlockPos)this.getBeamTarget()));
        }
        if (this.getDamageCloud() != null) {
            compound.putUUID("DamageCloudUUID", this.getDamageCloud());
        }
    }

    public boolean isPickable() {
        return true;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (source.getEntity() instanceof InnerDemonEntity) {
            return false;
        }
        Level level = this.level();
        if (this.isAlive() && !level.isClientSide) {
            List<InnerDemonEntity> demonsInRange = EntityUtils.getEntitiesInRange(level, this.position(), null, InnerDemonEntity.class, 16.0);
            if (!demonsInRange.isEmpty()) {
                LivingEntity trueSource = source.getEntity() instanceof LivingEntity ? (LivingEntity)source.getEntity() : null;
                for (InnerDemonEntity demon : demonsInRange) {
                    demon.hurt(level.damageSources().explosion((Entity)trueSource, null), 10.0f);
                }
            }
            this.discard();
            if (!source.is(DamageTypeTags.IS_EXPLOSION)) {
                level.explode(null, this.getX(), this.getY(), this.getZ(), 4.0f, Level.ExplosionInteraction.BLOCK);
            }
        }
        return true;
    }

    public void setBeamTarget(@Nullable BlockPos beamTarget) {
        this.getEntityData().set(BEAM_TARGET, Optional.ofNullable(beamTarget));
    }

    @Nullable
    public BlockPos getBeamTarget() {
        return ((Optional)this.getEntityData().get(BEAM_TARGET)).orElse(null);
    }

    public void setDamageCloud(@Nullable UUID cloudId) {
        this.getEntityData().set(DAMAGE_CLOUD, Optional.ofNullable(cloudId));
    }

    @Nullable
    public UUID getDamageCloud() {
        return ((Optional)this.getEntityData().get(DAMAGE_CLOUD)).orElse(null);
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return super.shouldRenderAtSqrDistance(distance) || this.getBeamTarget() != null;
    }
}

