/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.misc;

import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.entities.pixies.PixieRank;
import com.verdantartifice.primalmagick.common.entities.pixies.guardians.AbstractGuardianPixieEntity;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.misc.IPixieItem;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.tags.DamageTypeTagsPM;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PixieHouseEntity
extends Mob
implements NeutralMob {
    public static final EntityDataAccessor<ItemStack> DATA_HOUSED_PIXIE = SynchedEntityData.defineId(PixieHouseEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static final EntityDataAccessor<Optional<UUID>> DATA_DEPLOYED_PIXIE = SynchedEntityData.defineId(PixieHouseEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public static final EntityDataAccessor<Integer> DATA_ANGER_TIME = SynchedEntityData.defineId(PixieHouseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final UniformInt ANGER_TIME_RANGE = TimeUtil.rangeOfSeconds((int)20, (int)39);
    public static final long WOBBLE_TIME = 5L;
    private static final byte HIT_EVENT = 32;
    @NotNull
    private ItemStack housedPixie = ItemStack.EMPTY;
    @Nullable
    private AbstractGuardianPixieEntity deployedPixieCache;
    @Nullable
    private LivingEntity target;
    @Nullable
    protected UUID angerTarget;
    protected int targetTimestamp;
    public long lastHit;

    public PixieHouseEntity(EntityType<? extends PixieHouseEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder getAttributeModifiers() {
        return PixieHouseEntity.createLivingAttributes().add(Attributes.STEP_HEIGHT, 0.0).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    private boolean hasPhysics() {
        return !this.isNoGravity();
    }

    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && this.hasPhysics();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new DeployGuardianPixieGoal(this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((PixieHouseEntity)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_HOUSED_PIXIE, (Object)ItemStack.EMPTY);
        pBuilder.define(DATA_DEPLOYED_PIXIE, Optional.empty());
        pBuilder.define(DATA_ANGER_TIME, (Object)0);
    }

    public ItemStack getHousedPixie() {
        return this.housedPixie;
    }

    public void setHousedPixie(ItemStack pixie) {
        this.housedPixie = pixie.copy();
        this.entityData.set(DATA_HOUSED_PIXIE, (Object)this.housedPixie);
    }

    @NotNull
    public Optional<UUID> getDeployedPixieUUID() {
        return (Optional)this.entityData.get(DATA_DEPLOYED_PIXIE);
    }

    @Nullable
    public AbstractGuardianPixieEntity getDeployedPixie() {
        Level level;
        if (this.deployedPixieCache == null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.deployedPixieCache = ((Optional)this.entityData.get(DATA_DEPLOYED_PIXIE)).map(u -> {
                AbstractGuardianPixieEntity pixie;
                Entity patt0$temp = serverLevel.getEntity(u);
                return patt0$temp instanceof AbstractGuardianPixieEntity ? (pixie = (AbstractGuardianPixieEntity)patt0$temp) : null;
            }).orElse(null);
        }
        return this.deployedPixieCache;
    }

    public void setDeployedPixie(@NotNull AbstractGuardianPixieEntity pixie) {
        this.deployedPixieCache = pixie;
        this.entityData.set(DATA_DEPLOYED_PIXIE, Optional.of(pixie.getUUID()));
    }

    public void removeDeployedPixie() {
        AbstractGuardianPixieEntity pixie = this.getDeployedPixie();
        if (pixie != null) {
            this.deployedPixieCache = null;
            this.entityData.set(DATA_DEPLOYED_PIXIE, Optional.empty());
            pixie.discard();
        }
    }

    public void tick() {
        super.tick();
        ItemStack pixieStack = (ItemStack)this.entityData.get(DATA_HOUSED_PIXIE);
        if (!this.housedPixie.equals(pixieStack)) {
            this.setHousedPixie(pixieStack);
        }
    }

    public void aiStep() {
        super.aiStep();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.updatePersistentAnger(serverLevel, true);
        }
    }

    public Iterable<ItemStack> getArmorSlots() {
        return List.of();
    }

    public ItemStack getItemBySlot(EquipmentSlot equipmentSlot) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot equipmentSlot, ItemStack itemStack) {
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverLevel = (ServerLevel)level;
            this.readPersistentAngerSaveData((Level)serverLevel, compoundTag);
            if (compoundTag.hasUUID("DeployedPixie") && (entity = serverLevel.getEntity(compoundTag.getUUID("DeployedPixie"))) instanceof AbstractGuardianPixieEntity) {
                AbstractGuardianPixieEntity pixie = (AbstractGuardianPixieEntity)entity;
                this.setDeployedPixie(pixie);
            }
        }
        if (compoundTag.contains("HousedPixie", 10)) {
            this.setHousedPixie(ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)compoundTag.getCompound("HousedPixie")));
        }
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        this.addPersistentAngerSaveData(compoundTag);
        if (!this.housedPixie.isEmpty()) {
            compoundTag.put("HousedPixie", this.housedPixie.saveOptional((HolderLookup.Provider)this.registryAccess()));
        }
        if (this.deployedPixieCache != null) {
            compoundTag.putUUID("DeployedPixie", this.deployedPixieCache.getUUID());
        }
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity pEntity) {
    }

    public InteractionResult interactAt(Player pPlayer, Vec3 pVec, InteractionHand pHand) {
        ItemStack heldStack = pPlayer.getItemInHand(pHand);
        if (heldStack.getItem() instanceof IPixieItem) {
            ItemStack stack = heldStack.copyWithCount(1);
            this.setHousedPixie(stack);
            heldStack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        if (heldStack.isEmpty() && !this.housedPixie.isEmpty()) {
            ItemStack stack = this.housedPixie.copy();
            if (!pPlayer.getInventory().add(stack)) {
                pPlayer.drop(stack, false);
            }
            this.setHousedPixie(ItemStack.EMPTY);
            this.removeDeployedPixie();
            this.playSound(SoundEvents.BAT_HURT, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.interactAt(pPlayer, pVec, pHand);
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.isRemoved()) {
            return false;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (pSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                this.kill();
                return false;
            }
            if (!this.isInvulnerableTo(pSource)) {
                if (pSource.is(DamageTypeTags.IS_EXPLOSION)) {
                    this.brokenByAnything(serverLevel, pSource);
                    this.kill();
                    return false;
                }
                if (pSource.is(DamageTypeTagsPM.IGNITES_PIXIE_HOUSES)) {
                    if (this.isOnFire()) {
                        this.causeDamage(serverLevel, pSource, 0.15f);
                    } else {
                        this.igniteForSeconds(5.0f);
                    }
                    return false;
                }
                if (pSource.is(DamageTypeTagsPM.BURNS_PIXIE_HOUSES) && this.getHealth() > 0.5f) {
                    this.causeDamage(serverLevel, pSource, 4.0f);
                    return false;
                }
                boolean canBreak = pSource.is(DamageTypeTagsPM.CAN_BREAK_PIXIE_HOUSES);
                boolean alwaysKill = pSource.is(DamageTypeTagsPM.ALWAYS_KILLS_PIXIE_HOUSES);
                if (!canBreak && !alwaysKill) {
                    return false;
                }
                Entity entity = pSource.getEntity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (!player.getAbilities().mayBuild) {
                        return false;
                    }
                }
                if (pSource.isCreativePlayer()) {
                    this.playBrokenSound();
                    this.showBreakingParticles();
                    this.kill();
                    return true;
                }
                long i = serverLevel.getGameTime();
                if (i - this.lastHit > 5L && !alwaysKill) {
                    serverLevel.broadcastEntityEvent((Entity)this, (byte)32);
                    this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, pSource.getEntity());
                    this.lastHit = i;
                } else {
                    this.brokenByPlayer(serverLevel, pSource);
                    this.showBreakingParticles();
                    this.kill();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 32) {
            if (this.level().isClientSide) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_HIT, this.getSoundSource(), 0.3f, 1.0f, false);
                this.lastHit = this.level().getGameTime();
            }
        } else {
            super.handleEntityEvent(pId);
        }
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        double d0 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return pDistance < (d0 *= 64.0) * d0;
    }

    private void showBreakingParticles() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, Blocks.OAK_PLANKS.defaultBlockState()), this.getX(), this.getY(0.6666666666666666), this.getZ(), 10, (double)this.getBbWidth() / 4.0, (double)this.getBbHeight() / 4.0, (double)this.getBbWidth() / 4.0, 0.05);
        }
    }

    private void causeDamage(ServerLevel pLevel, DamageSource pDamageSource, float pDamageAmount) {
        float newHealth = this.getHealth() - pDamageAmount;
        if (newHealth <= 0.5f) {
            this.brokenByAnything(pLevel, pDamageSource);
            this.kill();
        } else {
            this.setHealth(newHealth);
            this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, pDamageSource.getEntity());
        }
    }

    private void brokenByPlayer(ServerLevel pLevel, DamageSource pDamageSource) {
        ItemStack itemstack = new ItemStack((ItemLike)ItemsPM.PIXIE_HOUSE.get());
        itemstack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
        Block.popResource((Level)this.level(), (BlockPos)this.blockPosition(), (ItemStack)itemstack);
        this.brokenByAnything(pLevel, pDamageSource);
    }

    private void brokenByAnything(ServerLevel pLevel, DamageSource pDamageSource) {
        this.playBrokenSound();
        this.dropAllDeathLoot(pLevel, pDamageSource);
        this.handlePixiesWhenBroken((Level)pLevel);
    }

    private void handlePixiesWhenBroken(Level level) {
        this.removeDeployedPixie();
        if (!this.housedPixie.isEmpty()) {
            Block.popResource((Level)level, (BlockPos)this.blockPosition().above(), (ItemStack)this.housedPixie);
            this.housedPixie = ItemStack.EMPTY;
        }
    }

    private void playBrokenSound() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_BREAK, this.getSoundSource(), 1.0f, 1.0f);
    }

    protected float tickHeadTurn(float pYRot, float pAnimStep) {
        this.yBodyRotO = this.yRotO;
        this.yBodyRot = this.getYRot();
        return 0.0f;
    }

    public void travel(Vec3 pTravelVector) {
        if (this.hasPhysics()) {
            super.travel(pTravelVector);
        }
    }

    public void kill() {
        this.handlePixiesWhenBroken(this.level());
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent((Holder)GameEvent.ENTITY_DIE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean skipAttackInteraction(Entity pEntity) {
        if (!(pEntity instanceof Player)) return false;
        Player player = (Player)pEntity;
        if (this.level().mayInteract(player, this.blockPosition())) return false;
        return true;
    }

    public LivingEntity.Fallsounds getFallSounds() {
        return new LivingEntity.Fallsounds(SoundEvents.ARMOR_STAND_FALL, SoundEvents.ARMOR_STAND_FALL);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return SoundEvents.ARMOR_STAND_HIT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ARMOR_STAND_BREAK;
    }

    public void thunderHit(ServerLevel pLevel, LightningBolt pLightning) {
    }

    public boolean isAffectedByPotions() {
        return false;
    }

    public boolean attackable() {
        return false;
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)ItemsPM.PIXIE_HOUSE.get());
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.entityData.set(DATA_ANGER_TIME, (Object)time);
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID target) {
        this.angerTarget = target;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_TIME_RANGE.sample(this.random));
    }

    public void setTarget(@Nullable LivingEntity livingEntity) {
        this.target = livingEntity;
        this.targetTimestamp = this.tickCount;
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }

    public int getTargetTimestamp() {
        return this.targetTimestamp;
    }

    public boolean canBeLeashed() {
        return false;
    }

    @Nullable
    private static EntityType<? extends AbstractGuardianPixieEntity> getGuardianEntityType(@NotNull ItemStack housedPixieStack) {
        Item item;
        if (!housedPixieStack.isEmpty() && (item = housedPixieStack.getItem()) instanceof IPixieItem) {
            IPixieItem pixieItem = (IPixieItem)item;
            return switch (pixieItem.getPixieRank()) {
                default -> throw new MatchException(null, null);
                case PixieRank.BASIC -> EntityTypesPM.BASIC_GUARDIAN_PIXIE.get();
                case PixieRank.GRAND -> EntityTypesPM.GRAND_GUARDIAN_PIXIE.get();
                case PixieRank.MAJESTIC -> EntityTypesPM.MAJESTIC_GUARDIAN_PIXIE.get();
            };
        }
        return null;
    }

    @Nullable
    private static Source getGuardianSource(@NotNull ItemStack housedPixieStack) {
        Item item;
        if (!housedPixieStack.isEmpty() && (item = housedPixieStack.getItem()) instanceof IPixieItem) {
            IPixieItem pixieItem = (IPixieItem)item;
            return pixieItem.getPixieSource();
        }
        return null;
    }

    public void deployGuardian() {
        Level level;
        EntityType<? extends AbstractGuardianPixieEntity> entityType = PixieHouseEntity.getGuardianEntityType(this.housedPixie);
        Source entitySource = PixieHouseEntity.getGuardianSource(this.housedPixie);
        if (entityType != null && entitySource != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 pos = this.getPosition(0.0f).add(0.0, 1.5, 0.0);
            AbstractGuardianPixieEntity pixie = AbstractGuardianPixieEntity.spawn(entityType, entitySource, this, serverLevel, BlockPos.containing((Position)pos));
            this.setDeployedPixie(pixie);
            this.level().playSound(null, pos.x(), pos.y(), pos.z(), SoundEvents.BEEHIVE_EXIT, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void undeployGuardian() {
        this.removeDeployedPixie();
        Vec3 pos = this.getPosition(0.0f).add(0.0, 1.5, 0.0);
        this.level().playSound(null, pos.x(), pos.y(), pos.z(), SoundEvents.BEEHIVE_ENTER, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected static class DeployGuardianPixieGoal
    extends Goal {
        private final PixieHouseEntity mob;

        public DeployGuardianPixieGoal(@NotNull PixieHouseEntity mob) {
            this.mob = mob;
        }

        public boolean canUse() {
            return this.mob.isAlive() && !this.mob.getHousedPixie().isEmpty() && this.mob.getDeployedPixie() == null && this.mob.getTarget() != null && this.mob.getTarget().isAlive();
        }

        public void start() {
            this.mob.deployGuardian();
        }
    }
}

