/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.misc;

import com.verdantartifice.primalmagick.common.entities.ai.goals.LongDistanceRangedAttackGoal;
import com.verdantartifice.primalmagick.common.entities.misc.SinCrystalEntity;
import com.verdantartifice.primalmagick.common.entities.projectiles.SinCrashEntity;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.sounds.SoundsPM;
import com.verdantartifice.primalmagick.common.spells.SpellPackage;
import com.verdantartifice.primalmagick.common.spells.SpellPropertiesPM;
import com.verdantartifice.primalmagick.common.spells.payloads.BloodDamageSpellPayload;
import com.verdantartifice.primalmagick.common.spells.vehicles.ProjectileSpellVehicle;
import com.verdantartifice.primalmagick.common.util.EntityUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class InnerDemonEntity
extends Monster
implements RangedAttackMob,
PowerableMob {
    public static final double HEAL_RANGE = 16.0;
    protected static final double SIN_CRASH_RANGE = 12.0;
    protected final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);
    protected boolean isSuffocating = false;
    protected List<SinCrystalEntity> crystalsInRange = new ArrayList<SinCrystalEntity>();

    public InnerDemonEntity(EntityType<? extends InnerDemonEntity> type, Level worldIn) {
        super(type, worldIn);
        this.getNavigation().setCanFloat(true);
        this.xpReward = 50;
    }

    public static AttributeSupplier.Builder getAttributeModifiers() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 400.0).add(Attributes.MOVEMENT_SPEED, 0.23).add(Attributes.FOLLOW_RANGE, 40.0).add(Attributes.ARMOR, 4.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.5).add(Attributes.ATTACK_DAMAGE, 12.0).add(Attributes.ATTACK_KNOCKBACK, 1.5);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SinCrashGoal(this, 100, 600));
        this.goalSelector.addGoal(3, new LongDistanceRangedAttackGoal<InnerDemonEntity>(this, 1.0, 30, 4.0f, 16.0f, true));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, false, false, null));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (this.hasCustomName()) {
            this.bossInfo.setName(this.getDisplayName());
        }
    }

    public void setCustomName(Component name) {
        super.setCustomName(name);
        this.bossInfo.setName(this.getDisplayName());
    }

    @Nonnull
    protected SpellPackage getSpellPackage() {
        Difficulty difficulty = this.level().getDifficulty();
        return SpellPackage.builder().name("Blood Ball").vehicle().type(ProjectileSpellVehicle.INSTANCE).end().payload().type(BloodDamageSpellPayload.INSTANCE).with(SpellPropertiesPM.POWER.get(), difficulty == Difficulty.EASY ? 1 : (difficulty == Difficulty.HARD ? 5 : 3)).end().build();
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        this.getSpellPackage().cast(this.level(), (LivingEntity)this, ItemStack.EMPTY);
    }

    public boolean isPowered() {
        return true;
    }

    public void aiStep() {
        Level level = this.level();
        this.crystalsInRange = EntityUtils.getEntitiesInRange(level, this.position(), null, SinCrystalEntity.class, 16.0);
        if (!this.crystalsInRange.isEmpty() && this.tickCount % 10 == 0 && !level.isClientSide) {
            this.heal(this.crystalsInRange.size());
        }
        super.aiStep();
    }

    protected void customServerAiStep() {
        Level level = this.level();
        if (!level.isClientSide) {
            if (this.isSuffocating && this.tickCount % 20 == 0) {
                Level.ExplosionInteraction mode = Services.EVENTS.canEntityGrief(level, (Entity)this) ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
                level.explode((Entity)this, this.getX(), this.getY(), this.getZ(), 7.0f, false, mode);
                this.isSuffocating = false;
            }
            this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
        }
        super.customServerAiStep();
    }

    public boolean doHurtTarget(Entity entityIn) {
        boolean retVal = super.doHurtTarget(entityIn);
        entityIn.igniteForSeconds(5.0f);
        return retVal;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source == this.level().damageSources().drown() || source.getEntity() instanceof InnerDemonEntity) {
            return false;
        }
        if (source == this.level().damageSources().inWall()) {
            this.isSuffocating = true;
        }
        return super.hurt(source, amount);
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        ItemEntity itemEntity = this.spawnAtLocation((ItemLike)ItemsPM.HALLOWED_ORB.get());
        if (itemEntity != null) {
            itemEntity.setExtendedLifetime();
        }
    }

    public void checkDespawn() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard();
        } else {
            this.noActionTime = 0;
        }
    }

    public boolean canBeAffected(MobEffectInstance potioneffectIn) {
        return false;
    }

    protected boolean canRide(Entity entityIn) {
        return false;
    }

    public boolean canUsePortal(boolean pAllowPassengers) {
        return false;
    }

    @Nonnull
    public List<SinCrystalEntity> getCrystalsInRange() {
        return Collections.unmodifiableList(this.crystalsInRange);
    }

    public void doSinCrash() {
        Level level = this.level();
        if (!level.isClientSide) {
            double demonPosX = this.getX();
            double demonPosY = this.getEyeY();
            double demonPosZ = this.getZ();
            Difficulty difficulty = level.getDifficulty();
            int crashCount = difficulty == Difficulty.EASY ? 1 : (difficulty == Difficulty.HARD ? 3 : 2);
            for (int index = 0; index < crashCount; ++index) {
                double dx = level.random.nextGaussian() * 12.0 * (level.random.nextBoolean() ? 1.0 : -1.0);
                double dy = -1.0 * (double)this.getEyeHeight();
                double dz = level.random.nextGaussian() * 12.0 * (level.random.nextBoolean() ? 1.0 : -1.0);
                SinCrashEntity crash = new SinCrashEntity(level, (LivingEntity)this, new Vec3(dx, dy, dz));
                crash.moveTo(demonPosX, demonPosY, demonPosZ, 0.0f, 0.0f);
                level.addFreshEntity((Entity)crash);
            }
            level.playSound(null, demonPosX, demonPosY, demonPosZ, SoundsPM.WHISPERS.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
    }

    public static class SinCrashGoal
    extends Goal {
        protected final InnerDemonEntity demon;
        protected final int startDelayTicks;
        protected final int cooldownTicks;
        protected int timer = -1;

        public SinCrashGoal(InnerDemonEntity demon, int startDelayTicks, int cooldownTicks) {
            this.demon = demon;
            this.startDelayTicks = startDelayTicks;
            this.cooldownTicks = cooldownTicks;
            this.timer = this.startDelayTicks;
        }

        public boolean canUse() {
            LivingEntity target = this.demon.getTarget();
            return target != null && target.isAlive();
        }

        public void stop() {
            this.timer = this.startDelayTicks;
        }

        public void tick() {
            if (--this.timer == 0) {
                this.demon.doSinCrash();
                this.timer = this.cooldownTicks;
            } else if (this.timer < 0) {
                this.timer = this.cooldownTicks;
            }
        }
    }
}

