/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.misc;

import com.verdantartifice.primalmagick.common.items.ItemsPM;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class FriendlyWitchEntity
extends AbstractVillager
implements NeutralMob,
RangedAttackMob {
    public static final String HONORED_NAME = "Corspilla";
    private static final ResourceLocation SPEED_MODIFIER_DRINKING_ID = ResourceLocation.withDefaultNamespace((String)"drinking");
    private static final AttributeModifier SPEED_MODIFIER_DRINKING = new AttributeModifier(SPEED_MODIFIER_DRINKING_ID, -0.25, AttributeModifier.Operation.ADD_VALUE);
    private static final EntityDataAccessor<Boolean> DATA_USING_ITEM = SynchedEntityData.defineId(FriendlyWitchEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.defineId(FriendlyWitchEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private static final List<VillagerTrades.ItemListing> TRADE_LISTINGS = (List)Util.make(new ArrayList(), list -> {
        list.add(new VillagerTrades.ItemsForEmeralds(ItemsPM.MYSTICAL_RELIC_FRAGMENT.get(), 1, 1, 5));
        list.add(new VillagerTrades.ItemsForEmeralds((Item)ItemsPM.BLOOD_NOTES.get(), 4, 1, 5));
        list.add(new VillagerTrades.ItemsForEmeralds((Item)ItemsPM.SHEEP_TOME.get(), 8, 1, 5));
    });
    protected UUID angerTarget;
    private int usingTime;

    public FriendlyWitchEntity(EntityType<? extends FriendlyWitchEntity> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.goalSelector.addGoal(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 60, 10.0f));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((FriendlyWitchEntity)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_USING_ITEM, (Object)false);
        pBuilder.define(ANGER_TIME, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.addPersistentAngerSaveData(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setAge(Math.max(0, this.getAge()));
        Level level = this.level();
        if (!level.isClientSide) {
            this.readPersistentAngerSaveData((Level)((ServerLevel)level), tag);
        }
    }

    public static AttributeSupplier.Builder getAttributeModifiers() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 26.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public void setUsingItem(boolean use) {
        this.getEntityData().set(DATA_USING_ITEM, (Object)use);
    }

    public boolean isDrinkingPotion() {
        return (Boolean)this.getEntityData().get(DATA_USING_ITEM);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        if (!this.isDrinkingPotion()) {
            Vec3 movement = target.getDeltaMovement();
            double dx = target.getX() + movement.x - this.getX();
            double dy = target.getEyeY() - (double)1.1f - this.getY();
            double dz = target.getZ() + movement.z - this.getZ();
            double dist = Math.sqrt(dx * dx + dz * dz);
            Holder potion = Potions.HARMING;
            if (dist >= 8.0 && !target.hasEffect(MobEffects.MOVEMENT_SLOWDOWN)) {
                potion = Potions.SLOWNESS;
            } else if (target.getHealth() >= 8.0f && !target.hasEffect(MobEffects.POISON)) {
                potion = Potions.POISON;
            } else if (dist <= 3.0 && !target.hasEffect(MobEffects.WEAKNESS) && this.random.nextFloat() < 0.25f) {
                potion = Potions.WEAKNESS;
            }
            Level level = this.level();
            ThrownPotion thrownpotion = new ThrownPotion(level, (LivingEntity)this);
            thrownpotion.setItem(PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)potion));
            thrownpotion.setXRot(thrownpotion.getXRot() - -20.0f);
            thrownpotion.shoot(dx, dy + dist * 0.2, dz, 0.75f, 8.0f);
            if (!this.isSilent()) {
                level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WITCH_THROW, this.getSoundSource(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
            }
            level.addFreshEntity((Entity)thrownpotion);
        }
    }

    protected void rewardTradeXp(MerchantOffer offer) {
        Level level = this.level();
        if (offer.shouldRewardExp()) {
            int i = 3 + this.random.nextInt(4);
            level.addFreshEntity((Entity)new ExperienceOrb(level, this.getX(), this.getY() + 0.5, this.getZ(), i));
        }
    }

    protected void updateTrades() {
        MerchantOffers offers = this.getOffers();
        for (VillagerTrades.ItemListing listing : TRADE_LISTINGS) {
            MerchantOffer offer = listing.getOffer((Entity)this, this.getRandom());
            if (offer == null) continue;
            offers.add((Object)offer);
        }
    }

    public boolean showProgressBar() {
        return false;
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return null;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        Level level = this.level();
        if (this.isAlive() && !this.isTrading() && !this.isBaby()) {
            if (!level.isClientSide) {
                if (this.getOffers().isEmpty()) {
                    return InteractionResult.CONSUME;
                }
                this.setTradingPlayer(player);
                this.openTradingScreen(player, this.getDisplayName(), 1);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public boolean removeWhenFarAway(double distSq) {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.WITCH_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.WITCH_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WITCH_DEATH;
    }

    public SoundEvent getNotifyTradeSound() {
        return SoundEvents.WITCH_CELEBRATE;
    }

    public void notifyTradeUpdated(ItemStack stack) {
    }

    public void aiStep() {
        Level level = this.level();
        if (!level.isClientSide && this.isAlive()) {
            if (this.isDrinkingPotion()) {
                if (this.usingTime-- <= 0) {
                    this.setUsingItem(false);
                    ItemStack stack = this.getMainHandItem();
                    this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                    PotionContents potionContents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
                    if (stack.is(Items.POTION) && potionContents != null) {
                        potionContents.forEachEffect(arg_0 -> ((FriendlyWitchEntity)this).addEffect(arg_0));
                    }
                    this.gameEvent((Holder)GameEvent.DRINK);
                    this.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(SPEED_MODIFIER_DRINKING.id());
                }
            } else {
                Holder potion = null;
                if (this.random.nextFloat() < 0.15f && this.isEyeInFluid(FluidTags.WATER) && !this.hasEffect(MobEffects.WATER_BREATHING)) {
                    potion = Potions.WATER_BREATHING;
                } else if (this.random.nextFloat() < 0.15f && (this.isOnFire() || this.getLastDamageSource() != null && this.getLastDamageSource().is(DamageTypeTags.IS_FIRE)) && !this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
                    potion = Potions.FIRE_RESISTANCE;
                } else if (this.random.nextFloat() < 0.05f && this.getHealth() < this.getMaxHealth()) {
                    potion = Potions.HEALING;
                } else if (this.random.nextFloat() < 0.5f && this.getTarget() != null && !this.hasEffect(MobEffects.MOVEMENT_SPEED) && this.getTarget().distanceToSqr((Entity)this) > 121.0) {
                    potion = Potions.SWIFTNESS;
                }
                if (potion != null) {
                    this.setItemSlot(EquipmentSlot.MAINHAND, PotionContents.createItemStack((Item)Items.POTION, (Holder)potion));
                    this.usingTime = this.getMainHandItem().getUseDuration((LivingEntity)this);
                    this.setUsingItem(true);
                    if (!this.isSilent()) {
                        level.playSound((Player)null, this.getX(), this.getY(), this.getZ(), SoundEvents.WITCH_DRINK, this.getSoundSource(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
                    }
                    AttributeInstance attr = this.getAttribute(Attributes.MOVEMENT_SPEED);
                    attr.removeModifier(SPEED_MODIFIER_DRINKING.id());
                    attr.addTransientModifier(SPEED_MODIFIER_DRINKING);
                }
            }
            if (this.random.nextFloat() < 7.5E-4f) {
                level.broadcastEntityEvent((Entity)this, (byte)15);
            }
        }
        super.aiStep();
    }

    public void handleEntityEvent(byte val) {
        if (val == 15) {
            for (int i = 0; i < this.random.nextInt(35) + 10; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.WITCH, this.getX() + this.random.nextGaussian() * (double)0.13f, this.getBoundingBox().maxY + 0.5 + this.random.nextGaussian() * (double)0.13f, this.getZ() + this.random.nextGaussian() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else {
            super.handleEntityEvent(val);
        }
    }

    protected float getDamageAfterMagicAbsorb(DamageSource source, float damage) {
        damage = super.getDamageAfterMagicAbsorb(source, damage);
        if (source.getEntity() == this) {
            damage = 0.0f;
        }
        if (source.is(DamageTypeTags.WITCH_RESISTANT_TO)) {
            damage *= 0.15f;
        }
        return damage;
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.getEntityData().get(ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.getEntityData().set(ANGER_TIME, (Object)time);
    }

    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }

    public void setPersistentAngerTarget(UUID target) {
        this.angerTarget = target;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_TIME_RANGE.sample(this.random));
    }
}

