/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.misc;

import com.verdantartifice.primalmagick.common.entities.EntityTypesPM;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.entities.FlyingCarpetItem;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class FlyingCarpetEntity
extends Entity {
    protected static final EntityDataAccessor<Integer> DYE_COLOR = SynchedEntityData.defineId(FlyingCarpetEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(FlyingCarpetEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private float momentum;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    private boolean forwardInputDown;
    private boolean backInputDown;

    public FlyingCarpetEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.blocksBuilding = true;
        this.setNoGravity(true);
    }

    public FlyingCarpetEntity(Level worldIn, double x, double y, double z) {
        this(EntityTypesPM.FLYING_CARPET.get(), worldIn);
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public FlyingCarpetEntity(Level worldIn, BlockPos pos) {
        this(worldIn, pos.getX(), pos.getY(), pos.getZ());
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(DYE_COLOR, (Object)-1);
        pBuilder.define(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }

    public boolean canCollideWith(Entity entity) {
        return (entity.canBeCollidedWith() || entity.isPushable()) && !this.isPassengerOfSameVehicle(entity);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPushable() {
        return true;
    }

    public Vec3 getRelativePortalPosition(Direction.Axis axis, BlockUtil.FoundRectangle result) {
        return LivingEntity.resetForwardDirectionOfRelativePortalPosition((Vec3)super.getRelativePortalPosition(axis, result));
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = 10;
    }

    public Direction getMotionDirection() {
        return this.getDirection().getClockWise();
    }

    public void tick() {
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        super.tick();
        this.tickLerp();
        Level level = this.level();
        if (this.isVehicle() && this.isControlledByLocalInstance()) {
            this.updateMotion();
            if (level.isClientSide) {
                this.controlCarpet();
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
        } else {
            this.setDeltaMovement(Vec3.ZERO);
            if (level.isClientSide) {
                this.updateInputs(false, false);
            }
        }
        this.checkInsideBlocks();
    }

    private void tickLerp() {
        if (this.isControlledByLocalInstance()) {
            this.lerpSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.lerpSteps > 0) {
            double newX = this.getX() + (this.lerpX - this.getX()) / (double)this.lerpSteps;
            double newY = this.getY() + (this.lerpY - this.getY()) / (double)this.lerpSteps;
            double newZ = this.getZ() + (this.lerpZ - this.getZ()) / (double)this.lerpSteps;
            double deltaYaw = Mth.wrapDegrees((double)(this.lerpYaw - (double)this.getYRot()));
            float yRot = (float)((double)this.getYRot() + deltaYaw / (double)this.lerpSteps);
            float xRot = (float)((double)this.getXRot() + (this.lerpPitch - (double)this.getXRot()) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.setPos(newX, newY, newZ);
            this.setRot(yRot, xRot);
        }
    }

    private void updateMotion() {
        this.momentum = 0.9f;
        this.setDeltaMovement(this.getDeltaMovement().scale((double)this.momentum).add(0.0, this.isNoGravity() ? 0.0 : -0.04, 0.0));
    }

    private void controlCarpet() {
        if (this.isVehicle()) {
            LivingEntity pilot = this.getControllingPassenger();
            this.yRotO = this.getYRot();
            this.setYRot(pilot.getYRot());
            float f = 0.0f;
            if (this.forwardInputDown) {
                f += 0.03f;
            }
            if (this.backInputDown) {
                f -= 0.005f;
            }
            Vec3 newMotion = this.getDeltaMovement().add((double)(Mth.sin((float)(-this.getYRot() * ((float)Math.PI / 180))) * f), (double)(Mth.sin((float)(-pilot.getXRot() * ((float)Math.PI / 180))) * f), (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * f));
            this.setDeltaMovement(newMotion);
        }
    }

    public void updateInputs(boolean forwardDown, boolean backwardDown) {
        this.forwardInputDown = forwardDown;
        this.backInputDown = backwardDown;
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.setYBodyRot(this.getYRot());
        float f = Mth.wrapDegrees((float)(entityToUpdate.getYRot() - this.getYRot()));
        float f1 = Mth.clamp((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.yRotO += f1 - f;
        entityToUpdate.setYRot(entityToUpdate.getYRot() + f1 - f);
        entityToUpdate.setYHeadRot(entityToUpdate.getYRot());
    }

    public void onPassengerTurned(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        Level level = this.level();
        if (!level.isClientSide && this.isAlive()) {
            if (player.isSecondaryUseActive()) {
                this.spawnAtLocation(this.getDropItem(), 0.0f);
                this.discard();
                return InteractionResult.SUCCESS;
            }
            player.startRiding((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    /*
     * Unable to fully structure code
     */
    public boolean hurt(DamageSource pSource, float pAmount) {
        block5: {
            level = this.level();
            if (this.isInvulnerableTo(pSource)) {
                return false;
            }
            if (level.isClientSide || this.isRemoved()) break block5;
            this.setDamage(this.getDamage() + pAmount * 10.0f);
            this.markHurt();
            this.gameEvent((Holder)GameEvent.ENTITY_DAMAGE, pSource.getEntity());
            var6_4 = pSource.getEntity();
            if (!(var6_4 instanceof Player)) ** GOTO lbl-1000
            player = (Player)var6_4;
            if (player.getAbilities().instabuild) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = flag = false;
            }
            if (flag || this.getDamage() > 40.0f) {
                if (level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                    this.spawnAtLocation(this.getDropItem(), 0.0f);
                }
                this.discard();
            }
            return true;
        }
        return true;
    }

    protected ItemStack getDropItem() {
        ItemStack stack = new ItemStack((ItemLike)ItemsPM.FLYING_CARPET.get());
        DyeColor color = this.getDyeColor();
        if (color != null) {
            ((FlyingCarpetItem)stack.getItem()).setDyeColor(stack, color);
        }
        return stack;
    }

    public DyeColor getDyeColor() {
        int value = (Integer)this.entityData.get(DYE_COLOR);
        if (value == -1) {
            return null;
        }
        return DyeColor.byId((int)value);
    }

    public void setDyeColor(DyeColor color) {
        if (color == null) {
            this.entityData.set(DYE_COLOR, (Object)-1);
        } else {
            this.entityData.set(DYE_COLOR, (Object)color.getId());
        }
    }

    public void setDamage(float damageTaken) {
        this.entityData.set(DAMAGE, (Object)Float.valueOf(damageTaken));
    }

    public float getDamage() {
        return ((Float)this.entityData.get(DAMAGE)).floatValue();
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.fallDistance = 0.0f;
        if (this.isVehicle()) {
            this.getControllingPassenger().fallDistance = 0.0f;
        }
    }

    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living;
        }
        return null;
    }

    protected void addPassenger(Entity passenger) {
        super.addPassenger(passenger);
        if (this.isControlledByLocalInstance() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.absMoveTo(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYaw, (float)this.lerpPitch);
        }
    }
}

