/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.golems;

import com.google.common.collect.ImmutableList;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerCompanions;
import com.verdantartifice.primalmagick.common.entities.ai.goals.CompanionOwnerHurtByTargetGoal;
import com.verdantartifice.primalmagick.common.entities.ai.goals.CompanionOwnerHurtTargetGoal;
import com.verdantartifice.primalmagick.common.entities.ai.goals.CompanionStayGoal;
import com.verdantartifice.primalmagick.common.entities.ai.goals.FollowCompanionOwnerGoal;
import com.verdantartifice.primalmagick.common.entities.companions.AbstractCompanionEntity;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractEnchantedGolemEntity
extends AbstractCompanionEntity
implements NeutralMob {
    protected static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.defineId(AbstractEnchantedGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected static final UniformInt ANGER_TIME_RANGE = TimeUtil.rangeOfSeconds((int)20, (int)39);
    protected int attackTimer;
    protected UUID angerTarget;
    protected long lastStayChangeTime;

    public AbstractEnchantedGolemEntity(EntityType<? extends AbstractEnchantedGolemEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.addPersistentAngerSaveData(compound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        Level level = this.level();
        super.readAdditionalSaveData(compound);
        if (!level.isClientSide) {
            this.readPersistentAngerSaveData((Level)((ServerLevel)level), compound);
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new CompanionStayGoal(this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(3, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.goalSelector.addGoal(6, (Goal)new FollowCompanionOwnerGoal(this, 1.0, 10.0f, 2.0f, false));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new CompanionOwnerHurtByTargetGoal(this));
        this.targetSelector.addGoal(2, (Goal)new CompanionOwnerHurtTargetGoal(this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((AbstractEnchantedGolemEntity)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(ANGER_TIME, (Object)0);
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    public int getAmbientSoundInterval() {
        return 120;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected void doPush(Entity entityIn) {
        if (entityIn instanceof Enemy && !(entityIn instanceof Creeper) && this.getRandom().nextInt(20) == 0) {
            this.setTarget((LivingEntity)entityIn);
        }
        super.doPush(entityIn);
    }

    public void aiStep() {
        int k;
        int j;
        int i;
        BlockPos pos;
        BlockState blockstate;
        boolean isAir;
        super.aiStep();
        Level level = this.level();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.getDeltaMovement().horizontalDistanceSqr() > 2.500000277905201E-7 && this.random.nextInt(5) == 0 && !(isAir = (blockstate = level.getBlockState(pos = new BlockPos(i = Mth.floor((double)this.getX()), j = Mth.floor((double)(this.getY() - (double)0.2f)), k = Mth.floor((double)this.getZ())))).isAir())) {
            level.addParticle((ParticleOptions)Services.PARTICLES.makeBlockParticleOptionWithPos((ParticleType<BlockParticleOption>)ParticleTypes.BLOCK, blockstate, pos), this.getX() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), this.getY() + 0.1, this.getZ() + ((double)this.random.nextFloat() - 0.5) * (double)this.getBbWidth(), 4.0 * ((double)this.random.nextFloat() - 0.5), 0.5, ((double)this.random.nextFloat() - 0.5) * 4.0);
        }
        if (!level.isClientSide) {
            this.updatePersistentAnger((ServerLevel)level, true);
        }
    }

    public boolean canAttack(LivingEntity target) {
        return this.isCompanionOwner(target) ? false : super.canAttack(target);
    }

    @Override
    public boolean shouldAttackEntity(LivingEntity target, Player owner) {
        if (target instanceof Creeper) {
            return false;
        }
        return super.shouldAttackEntity(target, owner);
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.entityData.set(ANGER_TIME, (Object)time);
    }

    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }

    public void setPersistentAngerTarget(UUID target) {
        this.angerTarget = target;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_TIME_RANGE.sample(this.random));
    }

    @Override
    public IPlayerCompanions.CompanionType getCompanionType() {
        return IPlayerCompanions.CompanionType.GOLEM;
    }

    public Cracks getCrackLevel() {
        return Cracks.getForHealthPercentage(this.getHealth() / this.getMaxHealth());
    }

    public boolean hurt(DamageSource source, float amount) {
        Cracks cracksBefore = this.getCrackLevel();
        boolean success = super.hurt(source, amount);
        if (success && cracksBefore != this.getCrackLevel()) {
            this.playSound(SoundEvents.IRON_GOLEM_DAMAGE, 1.0f, 1.0f);
        }
        return success;
    }

    public boolean doHurtTarget(Entity entityIn) {
        this.attackTimer = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        float rawDamage = (float)this.getAttributeValue(Attributes.ATTACK_DAMAGE);
        float damage = (int)rawDamage > 0 ? rawDamage / 2.0f + (float)this.random.nextInt((int)rawDamage) : rawDamage;
        DamageSource damageSource = this.damageSources().mobAttack((LivingEntity)this);
        boolean flag = entityIn.hurt(damageSource, damage);
        if (flag) {
            entityIn.setDeltaMovement(entityIn.getDeltaMovement().add(0.0, 0.4, 0.0));
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)entityIn, (DamageSource)damageSource);
            }
        }
        this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 1.0f, 1.0f);
        return flag;
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 1.0f, 1.0f);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.IRON_GOLEM_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.IRON_GOLEM_DEATH;
    }

    protected abstract TagKey<Item> getRepairMaterialTag();

    protected abstract float getRepairHealAmount();

    protected InteractionResult mobInteract(Player playerIn, InteractionHand hand) {
        Level level = this.level();
        ItemStack itemstack = playerIn.getItemInHand(hand);
        if (!itemstack.is(this.getRepairMaterialTag())) {
            InteractionResult actionResult = super.mobInteract(playerIn, hand);
            if (!actionResult.consumesAction() && this.isCompanionOwner((LivingEntity)playerIn) && !level.isClientSide) {
                long time = playerIn.level().getGameTime();
                if (this.lastStayChangeTime != time) {
                    this.setCompanionStaying(!this.isCompanionStaying());
                    if (this.isCompanionStaying()) {
                        playerIn.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.golem.stay"));
                    } else {
                        playerIn.sendSystemMessage((Component)Component.translatable((String)"event.primalmagick.golem.follow"));
                    }
                    this.lastStayChangeTime = time;
                }
                this.navigation.stop();
                this.setTarget(null);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        float healthBefore = this.getHealth();
        this.heal(this.getRepairHealAmount());
        if (this.getHealth() == healthBefore) {
            return InteractionResult.PASS;
        }
        this.playSound(SoundEvents.IRON_GOLEM_REPAIR, 1.0f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
        if (!playerIn.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound(SoundEvents.IRON_GOLEM_STEP, 1.0f, 1.0f);
    }

    public boolean checkSpawnObstruction(LevelReader worldIn) {
        BlockPos downPos = this.blockPosition().below();
        BlockState downState = worldIn.getBlockState(downPos);
        if (!downState.entityCanStandOn((BlockGetter)worldIn, downPos, (Entity)this)) {
            return false;
        }
        for (int i = 1; i < 3; ++i) {
            BlockState upState;
            BlockPos upPos = this.blockPosition().above(i);
            if (NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)worldIn, (BlockPos)upPos, (BlockState)(upState = worldIn.getBlockState(upPos)), (FluidState)upState.getFluidState(), (EntityType)this.getType())) continue;
            return false;
        }
        return NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)worldIn, (BlockPos)this.blockPosition(), (BlockState)worldIn.getBlockState(this.blockPosition()), (FluidState)Fluids.EMPTY.defaultFluidState(), (EntityType)this.getType()) && worldIn.isUnobstructed((Entity)this);
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.875f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    public static enum Cracks {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Cracks> SORTED_VALUES;
        private final float healthPercentage;

        private Cracks(float healthPercentage) {
            this.healthPercentage = healthPercentage;
        }

        public static Cracks getForHealthPercentage(float percentage) {
            for (Cracks cracks : SORTED_VALUES) {
                if (!(percentage < cracks.healthPercentage)) continue;
                return cracks;
            }
            return NONE;
        }

        static {
            SORTED_VALUES = (List)Stream.of(Cracks.values()).sorted(Comparator.comparingDouble(c -> c.healthPercentage)).collect(ImmutableList.toImmutableList());
        }
    }
}

