/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.companions;

import com.verdantartifice.primalmagick.common.entities.companions.AbstractCompanionEntity;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CompanionManager {
    private static final Set<UUID> SYNC_SET = ConcurrentHashMap.newKeySet();

    public static boolean isSyncScheduled(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        return SYNC_SET.remove(player.getUUID());
    }

    public static void scheduleSync(@Nullable Player player) {
        if (player != null) {
            SYNC_SET.add(player.getUUID());
        }
    }

    public static void addCompanion(@Nullable Player player, @Nullable AbstractCompanionEntity companion) {
        if (player != null && companion != null) {
            companion.setCompanionOwnerId(player.getUUID());
            Services.CAPABILITIES.companions(player).ifPresent(companions -> {
                Level patt0$temp;
                UUID oldCompanion = companions.add(companion.getCompanionType(), companion.getUUID());
                if (oldCompanion != null && (patt0$temp = player.level()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)patt0$temp;
                    for (ServerLevel serverWorld : serverLevel.getServer().getAllLevels()) {
                        Entity entity = serverWorld.getEntity(oldCompanion);
                        if (entity == null) continue;
                        entity.kill();
                        break;
                    }
                }
                CompanionManager.scheduleSync(player);
            });
        }
    }

    public static void removeCompanion(@Nullable Player player, @Nullable AbstractCompanionEntity companion) {
        if (player != null && companion != null) {
            companion.setCompanionOwnerId(null);
            Services.CAPABILITIES.companions(player).ifPresent(companions -> {
                if (companions.remove(companion.getCompanionType(), companion.getUUID())) {
                    CompanionManager.scheduleSync(player);
                }
            });
        }
    }

    public static boolean isCurrentCompanion(@Nullable Player player, @Nullable AbstractCompanionEntity companion) {
        if (player == null || companion == null) {
            return false;
        }
        return Services.CAPABILITIES.companions(player).map(c -> c.contains(companion.getCompanionType(), companion.getUUID())).orElse(false);
    }
}

