/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.companions;

import com.verdantartifice.primalmagick.common.capabilities.IPlayerCompanions;
import com.verdantartifice.primalmagick.common.entities.companions.CompanionManager;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;

public abstract class AbstractCompanionEntity
extends PathfinderMob {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.defineId(AbstractCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    protected boolean staying;

    protected AbstractCompanionEntity(EntityType<? extends AbstractCompanionEntity> entityType, Level world) {
        super(entityType, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(OWNER_UNIQUE_ID, Optional.empty());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("CompanionStaying", this.isCompanionStaying());
        if (this.hasCompanionOwner()) {
            compound.putUUID("CompanionOwner", this.getCompanionOwnerId());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setCompanionStaying(compound.getBoolean("CompanionStaying"));
        if (compound.hasUUID("CompanionOwner")) {
            this.setCompanionOwnerId(compound.getUUID("CompanionOwner"));
        } else {
            this.setCompanionOwnerId(null);
        }
    }

    @Nullable
    public UUID getCompanionOwnerId() {
        return ((Optional)this.entityData.get(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setCompanionOwnerId(@Nullable UUID ownerId) {
        this.entityData.set(OWNER_UNIQUE_ID, Optional.ofNullable(ownerId));
    }

    @Nullable
    public Player getCompanionOwner() {
        try {
            UUID ownerId = this.getCompanionOwnerId();
            return ownerId == null ? null : this.level().getPlayerByUUID(ownerId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean hasCompanionOwner() {
        return this.getCompanionOwnerId() != null;
    }

    public boolean isCompanionOwner(LivingEntity entity) {
        return entity instanceof Player && (Player)entity == this.getCompanionOwner();
    }

    public PlayerTeam getTeam() {
        Player owner;
        if (this.hasCompanionOwner() && (owner = this.getCompanionOwner()) != null) {
            return owner.getTeam();
        }
        return super.getTeam();
    }

    public boolean isAlliedTo(Entity other) {
        if (this.hasCompanionOwner()) {
            Player owner = this.getCompanionOwner();
            if (other == owner) {
                return true;
            }
            if (owner != null) {
                return owner.isAlliedTo(other);
            }
        }
        return super.isAlliedTo(other);
    }

    public boolean isCompanionStaying() {
        return this.staying;
    }

    public void setCompanionStaying(boolean stay) {
        this.staying = stay;
    }

    public boolean shouldAttackEntity(LivingEntity target, Player owner) {
        if (target instanceof AbstractCompanionEntity) {
            AbstractCompanionEntity otherCompanion = (AbstractCompanionEntity)target;
            return !otherCompanion.hasCompanionOwner() || otherCompanion.getCompanionOwner() != owner;
        }
        if (target instanceof Player && !owner.canHarmPlayer((Player)target)) {
            return false;
        }
        if (target instanceof AbstractHorse && ((AbstractHorse)target).isTamed()) {
            return false;
        }
        return !(target instanceof TamableAnimal) || !((TamableAnimal)target).isTame();
    }

    public abstract IPlayerCompanions.CompanionType getCompanionType();

    public void remove(Entity.RemovalReason reason) {
        if (this.hasCompanionOwner()) {
            CompanionManager.removeCompanion(this.getCompanionOwner(), this);
        }
        super.remove(reason);
    }

    public void die(DamageSource cause) {
        Level level = this.level();
        if (!level.isClientSide && level.getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && this.getCompanionOwner() instanceof ServerPlayer) {
            this.getCompanionOwner().sendSystemMessage(this.getCombatTracker().getDeathMessage());
        }
        super.die(cause);
    }

    public void tick() {
        Player owner;
        super.tick();
        Level level = this.level();
        if (!level.isClientSide && this.tickCount % 100 == 0 && (owner = this.getCompanionOwner()) != null && !CompanionManager.isCurrentCompanion(owner, this)) {
            this.setCompanionOwnerId(null);
            this.kill();
        }
    }
}

