/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.ai.sensing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.verdantartifice.primalmagick.common.entities.ai.memory.MemoryModuleTypesPM;
import com.verdantartifice.primalmagick.common.entities.treefolk.TreefolkAi;
import com.verdantartifice.primalmagick.common.entities.treefolk.TreefolkEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.player.Player;

public class TreefolkSpecificSensor
extends Sensor<LivingEntity> {
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM, MemoryModuleTypesPM.NEAREST_VISIBLE_ADULT_TREEFOLK.get(), MemoryModuleTypesPM.NEARBY_ADULT_TREEFOLK.get(), MemoryModuleTypesPM.NEARBY_TREEFOLK.get(), (Object[])new MemoryModuleType[0]);
    }

    protected void doTick(ServerLevel pLevel, LivingEntity pEntity) {
        TreefolkEntity treefolk;
        Brain brain = pEntity.getBrain();
        Optional<Object> playerHoldingWantedItemOpt = Optional.empty();
        ArrayList<TreefolkEntity> nearbyTreefolkList = new ArrayList<TreefolkEntity>();
        ArrayList<TreefolkEntity> nearbyAdultTreefolkList = new ArrayList<TreefolkEntity>();
        ArrayList<TreefolkEntity> nearestVisibleAdultTreefolkList = new ArrayList<TreefolkEntity>();
        NearestVisibleLivingEntities visibleEntities = brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty());
        for (LivingEntity living : visibleEntities.findAll(e -> true)) {
            if (living instanceof TreefolkEntity) {
                treefolk = (TreefolkEntity)living;
                nearbyTreefolkList.add(treefolk);
                if (!treefolk.isAdult()) continue;
                nearestVisibleAdultTreefolkList.add(treefolk);
                continue;
            }
            if (!(living instanceof Player)) continue;
            Player player = (Player)living;
            if (!playerHoldingWantedItemOpt.isEmpty() || player.isSpectator() || !TreefolkAi.isPlayerHoldingLovedItem((LivingEntity)player)) continue;
            playerHoldingWantedItemOpt = Optional.of(player);
        }
        for (LivingEntity living : (List)brain.getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).orElse(ImmutableList.of())) {
            if (!(living instanceof TreefolkEntity) || !(treefolk = (TreefolkEntity)living).isAdult()) continue;
            nearbyAdultTreefolkList.add(treefolk);
        }
        brain.setMemory(MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM, playerHoldingWantedItemOpt);
        brain.setMemory(MemoryModuleTypesPM.NEARBY_TREEFOLK.get(), nearbyTreefolkList);
        brain.setMemory(MemoryModuleTypesPM.NEARBY_ADULT_TREEFOLK.get(), nearbyAdultTreefolkList);
        brain.setMemory(MemoryModuleTypesPM.NEAREST_VISIBLE_ADULT_TREEFOLK.get(), nearestVisibleAdultTreefolkList);
    }
}

