/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.ai.sensing;

import com.google.common.collect.ImmutableSet;
import com.verdantartifice.primalmagick.common.entities.ai.memory.MemoryModuleTypesPM;
import com.verdantartifice.primalmagick.common.tags.BlockTagsPM;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;

public class NearestValidFertilizableBlockSensor
extends Sensor<PathfinderMob> {
    private static final int SCAN_RATE = 40;
    private static final int SCAN_XZ_RADIUS = 4;
    private static final int SCAN_Y_RADIUS = 2;

    public NearestValidFertilizableBlockSensor() {
        super(40);
    }

    protected void doTick(ServerLevel pLevel, PathfinderMob pEntity) {
        BlockPos blockPos = pEntity.blockPosition();
        ArrayList<BlockPos> nearby = new ArrayList<BlockPos>();
        for (int x = -4; x <= 4; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    BonemealableBlock bonemealable;
                    BlockPos scanPos = blockPos.offset(x, y, z);
                    BlockState scanState = pLevel.getBlockState(scanPos);
                    Block block = scanState.getBlock();
                    if (!(block instanceof BonemealableBlock) || !(bonemealable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)pLevel, scanPos, scanState) || scanState.is(BlockTagsPM.TREEFOLK_FERTILIZE_EXEMPT)) continue;
                    nearby.add(scanPos);
                }
            }
        }
        nearby.sort(Comparator.comparingDouble(arg_0 -> ((BlockPos)blockPos).distSqr(arg_0)));
        Brain brain = pEntity.getBrain();
        if (!nearby.isEmpty()) {
            brain.setMemory(MemoryModuleTypesPM.NEAREST_VALID_FERTILIZABLE_BLOCKS.get(), nearby);
        } else {
            brain.eraseMemory(MemoryModuleTypesPM.NEAREST_VALID_FERTILIZABLE_BLOCKS.get());
        }
    }

    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleTypesPM.NEAREST_VALID_FERTILIZABLE_BLOCKS.get());
    }
}

