/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.ai.goals;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class LongDistanceRangedAttackGoal<T extends PathfinderMob>
extends Goal {
    protected final T entity;
    protected final double moveSpeed;
    protected final int minAttackTime;
    protected final int maxAttackTime;
    protected final float minDistanceSq;
    protected final float maxDistanceSq;
    protected final float maxDistance;
    protected final boolean advanceToMelee;
    protected LivingEntity attackTarget;
    protected int rangedAttackTime = -1;
    protected int seeTime;

    public LongDistanceRangedAttackGoal(T attacker, double moveSpeed, int maxAttackTime, float minDistance, float maxDistance, boolean advanceToMelee) {
        this(attacker, moveSpeed, maxAttackTime, maxAttackTime, minDistance, maxDistance, advanceToMelee);
    }

    public LongDistanceRangedAttackGoal(T attacker, double moveSpeed, int minAttackTime, int maxAttackTime, float minDistance, float maxDistance, boolean advanceToMelee) {
        this.entity = attacker;
        this.moveSpeed = moveSpeed;
        this.minAttackTime = minAttackTime;
        this.maxAttackTime = maxAttackTime;
        this.minDistanceSq = minDistance * minDistance;
        this.maxDistanceSq = maxDistance * maxDistance;
        this.maxDistance = maxDistance;
        this.advanceToMelee = advanceToMelee;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity target = this.entity.getTarget();
        if (target != null && target.isAlive() && this.entity.distanceToSqr((Entity)target) > (double)this.minDistanceSq) {
            this.attackTarget = target;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.canUse() || !this.entity.getNavigation().isDone();
    }

    public void stop() {
        this.attackTarget = null;
        this.seeTime = 0;
        this.rangedAttackTime = -1;
    }

    public void tick() {
        float distSq = (float)this.entity.distanceToSqr((Entity)this.attackTarget);
        boolean canSee = this.entity.getSensing().hasLineOfSight((Entity)this.attackTarget);
        this.seeTime = canSee ? ++this.seeTime : 0;
        if (this.seeTime < 5 || distSq > this.maxDistanceSq || distSq > this.minDistanceSq && this.advanceToMelee) {
            this.entity.getNavigation().moveTo((Entity)this.attackTarget, this.moveSpeed);
        } else {
            this.entity.getNavigation().stop();
        }
        this.entity.getLookControl().setLookAt((Entity)this.attackTarget, 30.0f, 30.0f);
        if (--this.rangedAttackTime == 0) {
            if (!canSee) {
                return;
            }
            float f = Mth.sqrt((float)distSq) / this.maxDistance;
            ((RangedAttackMob)this.entity).performRangedAttack(this.attackTarget, Mth.clamp((float)f, (float)0.1f, (float)1.0f));
            this.rangedAttackTime = Mth.floor((float)(f * (float)(this.maxAttackTime - this.minAttackTime) + (float)this.minAttackTime));
        } else if (this.rangedAttackTime < 0) {
            float f = Mth.sqrt((float)distSq) / this.maxDistance;
            this.rangedAttackTime = Mth.floor((float)(f * (float)(this.maxAttackTime - this.minAttackTime) + (float)this.minAttackTime));
        }
    }
}

