/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.ai.goals;

import com.verdantartifice.primalmagick.common.entities.companions.AbstractCompanionEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class FollowCompanionOwnerGoal
extends Goal {
    protected final AbstractCompanionEntity entity;
    protected Player owner;
    protected final LevelReader world;
    protected final double followSpeed;
    protected final PathNavigation navigator;
    protected int timeToRecalcPath;
    protected final float maxDist;
    protected final float minDist;
    protected float oldWaterCost;
    protected final boolean teleportToLeaves;

    public FollowCompanionOwnerGoal(AbstractCompanionEntity entity, double speed, float minDist, float maxDist, boolean teleportToLeaves) {
        this.entity = entity;
        this.world = entity.level();
        this.followSpeed = speed;
        this.navigator = entity.getNavigation();
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.teleportToLeaves = teleportToLeaves;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(this.navigator instanceof GroundPathNavigation) && !(this.navigator instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowCompanionOwnerGoal");
        }
    }

    public boolean canUse() {
        Player owner = this.entity.getCompanionOwner();
        if (owner == null) {
            return false;
        }
        if (owner.isSpectator()) {
            return false;
        }
        if (this.entity.isCompanionStaying()) {
            return false;
        }
        if (this.entity.distanceToSqr((Entity)owner) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.navigator.isDone()) {
            return false;
        }
        if (this.entity.isCompanionStaying()) {
            return false;
        }
        return !(this.entity.distanceToSqr((Entity)this.owner) <= (double)(this.maxDist * this.maxDist));
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.getPathfindingMalus(PathType.WATER);
        this.entity.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public void stop() {
        this.owner = null;
        this.navigator.stop();
        this.entity.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    public void tick() {
        this.entity.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.entity.getMaxHeadXRot());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.entity.isLeashed() && !this.entity.isPassenger()) {
                if (this.entity.distanceToSqr((Entity)this.owner) >= 324.0) {
                    this.tryToTeleportNearEntity();
                } else {
                    this.navigator.moveTo((Entity)this.owner, this.followSpeed);
                }
            }
        }
    }

    protected void tryToTeleportNearEntity() {
        BlockPos pos = this.owner.blockPosition();
        for (int attempts = 0; attempts < 10; ++attempts) {
            int dx = this.getRandomNumber(-2, 2);
            int dy = this.getRandomNumber(-1, 1);
            int dz = this.getRandomNumber(-2, 2);
            if (!this.tryToTeleportToLocation(pos.getX() + dx, pos.getY() + dy, pos.getZ() + dz)) continue;
            return;
        }
    }

    protected boolean tryToTeleportToLocation(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.getX()) < 2.0 && Math.abs((double)z - this.owner.getZ()) < 2.0) {
            return false;
        }
        if (!this.isTeleportFriendlyBlock(new BlockPos(x, y, z))) {
            return false;
        }
        this.entity.moveTo((double)x + 0.5, y, (double)z + 0.5, this.entity.getYRot(), this.entity.getXRot());
        this.navigator.stop();
        return true;
    }

    protected boolean isTeleportFriendlyBlock(BlockPos pos) {
        PathfindingContext context = new PathfindingContext((CollisionGetter)this.world, (Mob)this.entity);
        PathType type = WalkNodeEvaluator.getPathTypeStatic((PathfindingContext)context, (BlockPos.MutableBlockPos)pos.mutable());
        if (type != PathType.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.world.getBlockState(pos.below());
        if (!this.teleportToLeaves && blockstate.getBlock() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.subtract((Vec3i)this.entity.blockPosition());
        return this.world.noCollision((Entity)this.entity, this.entity.getBoundingBox().move(blockpos));
    }

    protected int getRandomNumber(int min, int max) {
        return this.entity.getRandom().nextInt(max - min + 1) + min;
    }
}

