/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.ai.goals;

import com.verdantartifice.primalmagick.common.entities.companions.AbstractCompanionEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class CompanionStayGoal
extends Goal {
    protected final AbstractCompanionEntity entity;

    public CompanionStayGoal(AbstractCompanionEntity entity) {
        this.entity = entity;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean canContinueToUse() {
        return this.entity.isCompanionStaying();
    }

    public boolean canUse() {
        if (!this.entity.hasCompanionOwner()) {
            return false;
        }
        if (this.entity.isInWaterOrBubble()) {
            return false;
        }
        if (!this.entity.onGround()) {
            return false;
        }
        Player owner = this.entity.getCompanionOwner();
        if (owner == null) {
            return true;
        }
        return this.entity.distanceToSqr((Entity)owner) < 144.0 && owner.getLastHurtByMob() != null ? false : this.entity.isCompanionStaying();
    }

    public void start() {
        this.entity.getNavigation().stop();
        this.entity.setCompanionStaying(true);
    }

    public void stop() {
        this.entity.setCompanionStaying(false);
    }
}

