/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.ai.goals;

import com.verdantartifice.primalmagick.common.entities.companions.AbstractCompanionEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class CompanionOwnerHurtTargetGoal
extends TargetGoal {
    protected final AbstractCompanionEntity entity;
    protected LivingEntity attacked;
    protected int timestamp;

    public CompanionOwnerHurtTargetGoal(AbstractCompanionEntity entity) {
        super((Mob)entity, false);
        this.entity = entity;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        if (this.entity.hasCompanionOwner() && !this.entity.isCompanionStaying()) {
            Player owner = this.entity.getCompanionOwner();
            if (owner == null) {
                return false;
            }
            this.attacked = owner.getLastHurtMob();
            int time = owner.getLastHurtMobTimestamp();
            return time != this.timestamp && this.canAttack(this.attacked, TargetingConditions.DEFAULT) && this.entity.shouldAttackEntity(this.attacked, owner);
        }
        return false;
    }

    public void start() {
        this.mob.setTarget(this.attacked);
        Player owner = this.entity.getCompanionOwner();
        if (owner != null) {
            this.timestamp = owner.getLastHurtMobTimestamp();
        }
        super.start();
    }
}

