/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.ai.goals;

import com.verdantartifice.primalmagick.common.entities.companions.AbstractCompanionEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class CompanionOwnerHurtByTargetGoal
extends TargetGoal {
    protected final AbstractCompanionEntity entity;
    protected LivingEntity attacker;
    protected int timestamp;

    public CompanionOwnerHurtByTargetGoal(AbstractCompanionEntity defendingCompanion) {
        super((Mob)defendingCompanion, false);
        this.entity = defendingCompanion;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        if (this.entity.hasCompanionOwner() && !this.entity.isCompanionStaying()) {
            Player owner = this.entity.getCompanionOwner();
            if (owner == null) {
                return false;
            }
            this.attacker = owner.getLastHurtByMob();
            int time = owner.getLastHurtByMobTimestamp();
            return time != this.timestamp && this.canAttack(this.attacker, TargetingConditions.DEFAULT) && this.entity.shouldAttackEntity(this.attacker, owner);
        }
        return false;
    }

    public void start() {
        this.mob.setTarget(this.attacker);
        Player owner = this.entity.getCompanionOwner();
        if (owner != null) {
            this.timestamp = owner.getLastHurtByMobTimestamp();
        }
        super.start();
    }
}

