/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.entities.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class LongDistanceRangedAttack<E extends Mob>
extends Behavior<E> {
    protected final int cooldownBetweenAttacks;
    protected final float minDistanceSq;
    protected final float maxDistanceSq;
    protected final float maxDistance;

    public LongDistanceRangedAttack(int cooldownBetweenAttacks, float minDistance, float maxDistance) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryStatus.VALUE_ABSENT));
        this.cooldownBetweenAttacks = cooldownBetweenAttacks;
        this.minDistanceSq = minDistance * minDistance;
        this.maxDistanceSq = maxDistance * maxDistance;
        this.maxDistance = maxDistance;
    }

    protected void start(ServerLevel pLevel, E pEntity, long pGameTime) {
        LivingEntity livingentity = this.getAttackTarget((Mob)pEntity);
        BehaviorUtils.lookAtEntity(pEntity, (LivingEntity)livingentity);
        float distSqr = (float)pEntity.distanceToSqr((Entity)livingentity);
        float f = Mth.sqrt((float)distSqr) / this.maxDistance;
        ((RangedAttackMob)pEntity).performRangedAttack(livingentity, Mth.clamp((float)f, (float)0.1f, (float)1.0f));
        pEntity.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (long)this.cooldownBetweenAttacks);
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, E pOwner) {
        LivingEntity livingentity = this.getAttackTarget((Mob)pOwner);
        double distSqr = pOwner.distanceToSqr((Entity)livingentity);
        return BehaviorUtils.canSee(pOwner, (LivingEntity)livingentity) && distSqr > (double)this.minDistanceSq && distSqr <= (double)this.maxDistanceSq;
    }

    private LivingEntity getAttackTarget(Mob mob) {
        return (LivingEntity)mob.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
    }
}

