/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.enchantments.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;

public record ApplyStackingMobEffect(Holder<MobEffect> toApply, LevelBasedValue duration, LevelBasedValue amplifierIncreasePerHit, LevelBasedValue maxAmplifier) implements EnchantmentEntityEffect
{
    public static final MapCodec<ApplyStackingMobEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MobEffect.CODEC.fieldOf("toApply").forGetter(ApplyStackingMobEffect::toApply), (App)LevelBasedValue.CODEC.fieldOf("duration").forGetter(ApplyStackingMobEffect::duration), (App)LevelBasedValue.CODEC.fieldOf("amplifierIncreasePerHit").forGetter(ApplyStackingMobEffect::amplifierIncreasePerHit), (App)LevelBasedValue.CODEC.fieldOf("maxAmplifier").forGetter(ApplyStackingMobEffect::maxAmplifier)).apply((Applicative)instance, ApplyStackingMobEffect::new));

    public void apply(ServerLevel pLevel, int pEnchantmentLevel, EnchantedItemInUse pItem, Entity pEntity, Vec3 pOrigin) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)pEntity;
            MobEffectInstance effectInstance = livingTarget.getEffect(this.toApply);
            int duration = Math.round(this.duration.calculate(pEnchantmentLevel));
            int ampIncrease = Math.round(this.amplifierIncreasePerHit.calculate(pEnchantmentLevel));
            int maxAmp = Math.round(this.maxAmplifier.calculate(pEnchantmentLevel));
            int newAmplifier = effectInstance == null ? 0 : Mth.clamp((int)(ampIncrease + effectInstance.getAmplifier()), (int)0, (int)(maxAmp - 1));
            livingTarget.addEffect(new MobEffectInstance(this.toApply, duration, newAmplifier));
        }
    }

    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }
}

