/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.enchantments.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;

public record ApplyConstantMobEffect(Holder<MobEffect> toApply, LevelBasedValue duration, LevelBasedValue amplifier) implements EnchantmentEntityEffect
{
    public static final MapCodec<ApplyConstantMobEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MobEffect.CODEC.fieldOf("toApply").forGetter(ApplyConstantMobEffect::toApply), (App)LevelBasedValue.CODEC.fieldOf("duration").forGetter(ApplyConstantMobEffect::duration), (App)LevelBasedValue.CODEC.fieldOf("amplifier").forGetter(ApplyConstantMobEffect::amplifier)).apply((Applicative)instance, ApplyConstantMobEffect::new));

    public void apply(ServerLevel pLevel, int pEnchantmentLevel, EnchantedItemInUse pItem, Entity pEntity, Vec3 pOrigin) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)pEntity;
            livingTarget.addEffect(new MobEffectInstance(this.toApply, Math.round(this.duration.calculate(pEnchantmentLevel)), Math.round(this.amplifier.calculate(pEnchantmentLevel))));
        }
    }

    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }
}

