/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.enchantments;

import com.verdantartifice.primalmagick.common.effects.EffectsPM;
import com.verdantartifice.primalmagick.common.enchantments.effects.ApplyConstantMobEffect;
import com.verdantartifice.primalmagick.common.enchantments.effects.ApplyStackingMobEffect;
import com.verdantartifice.primalmagick.common.enchantments.effects.Lifesteal;
import com.verdantartifice.primalmagick.common.tags.DamageTypeTagsPM;
import com.verdantartifice.primalmagick.common.tags.EnchantmentTagsPM;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.AddValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentAttributeEffect;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.DamageSourceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;

public class EnchantmentsPM {
    public static final ResourceKey<Enchantment> LIFESTEAL = EnchantmentsPM.key("lifesteal");
    public static final ResourceKey<Enchantment> ENDERLOCK = EnchantmentsPM.key("enderlock");
    public static final ResourceKey<Enchantment> JUDGMENT = EnchantmentsPM.key("judgment");
    public static final ResourceKey<Enchantment> ENDERPORT = EnchantmentsPM.key("enderport");
    public static final ResourceKey<Enchantment> REGROWTH = EnchantmentsPM.key("regrowth");
    public static final ResourceKey<Enchantment> AEGIS = EnchantmentsPM.key("aegis");
    public static final ResourceKey<Enchantment> MANA_EFFICIENCY = EnchantmentsPM.key("mana_efficiency");
    public static final ResourceKey<Enchantment> SPELL_POWER = EnchantmentsPM.key("spell_power");
    public static final ResourceKey<Enchantment> TREASURE = EnchantmentsPM.key("treasure");
    public static final ResourceKey<Enchantment> BLUDGEONING = EnchantmentsPM.key("bludgeoning");
    public static final ResourceKey<Enchantment> REVERBERATION = EnchantmentsPM.key("reverberation");
    public static final ResourceKey<Enchantment> BOUNTY = EnchantmentsPM.key("bounty");
    public static final ResourceKey<Enchantment> DISINTEGRATION = EnchantmentsPM.key("disintegration");
    public static final ResourceKey<Enchantment> VERDANT = EnchantmentsPM.key("verdant");
    public static final ResourceKey<Enchantment> LUCKY_STRIKE = EnchantmentsPM.key("lucky_strike");
    public static final ResourceKey<Enchantment> RENDING = EnchantmentsPM.key("rending");
    public static final ResourceKey<Enchantment> SOULPIERCING = EnchantmentsPM.key("soulpiercing");
    public static final ResourceKey<Enchantment> ESSENCE_THIEF = EnchantmentsPM.key("essence_thief");
    public static final ResourceKey<Enchantment> BULWARK = EnchantmentsPM.key("bulwark");
    public static final ResourceKey<Enchantment> MAGICK_PROTECTION = EnchantmentsPM.key("magick_protection");
    public static final ResourceKey<Enchantment> GUILLOTINE = EnchantmentsPM.key("guillotine");
    public static final ResourceKey<Enchantment> PONDERING = EnchantmentsPM.key("pondering");

    public static void bootstrap(BootstrapContext<Enchantment> pContext) {
        HolderGetter itemHolderGetter = pContext.lookup(Registries.ITEM);
        HolderGetter enchantmentHolderGetter = pContext.lookup(Registries.ENCHANTMENT);
        EnchantmentsPM.register(pContext, LIFESTEAL, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.MELEE_ENCHANTABLE), (HolderSet)itemHolderGetter.getOrThrow(ItemTags.SWORD_ENCHANTABLE), (int)2, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)10), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.VICTIM, (Object)new Lifesteal((LevelBasedValue)LevelBasedValue.perLevel((float)0.2f)), DamageSourceCondition.hasDamageSource((DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().isDirect(true))));
        EnchantmentsPM.register(pContext, ENDERLOCK, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.MELEE_ENCHANTABLE), (HolderSet)itemHolderGetter.getOrThrow(ItemTags.SWORD_ENCHANTABLE), (int)2, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)10), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.VICTIM, (Object)new ApplyConstantMobEffect(EffectsPM.ENDERLOCK.getHolder(), (LevelBasedValue)LevelBasedValue.perLevel((float)40.0f), (LevelBasedValue)LevelBasedValue.constant((float)0.0f))));
        EnchantmentsPM.register(pContext, JUDGMENT, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.MELEE_ENCHANTABLE), (int)1, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)10, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)35, (int)10), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).exclusiveWith((HolderSet)enchantmentHolderGetter.getOrThrow(EnchantmentTags.DAMAGE_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)1.0f, (float)0.5f))).withEffect(EnchantmentEffectComponents.DAMAGE, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)2.5f)), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().entityType(EntityTypePredicate.of((TagKey)EntityTypeTags.SENSITIVE_TO_SMITE)))));
        EnchantmentsPM.register(pContext, ENDERPORT, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.ARCHERY_ENCHANTABLE), (int)2, (int)1, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)10), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})));
        EnchantmentsPM.register(pContext, REGROWTH, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTags.DURABILITY_ENCHANTABLE), (int)1, (int)1, (Enchantment.Cost)Enchantment.constantCost((int)30), (Enchantment.Cost)Enchantment.constantCost((int)90), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY})));
        EnchantmentsPM.register(pContext, AEGIS, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTags.ARMOR_ENCHANTABLE), (int)1, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)10, (int)11), (Enchantment.Cost)Enchantment.dynamicCost((int)18, (int)11), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ARMOR})).exclusiveWith((HolderSet)enchantmentHolderGetter.getOrThrow(EnchantmentTags.ARMOR_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE_PROTECTION, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)2.0f)), (LootItemCondition.Builder)AllOfCondition.allOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{DamageSourceCondition.hasDamageSource((DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is((TagKey)DamageTypeTags.IS_FIRE)).tag(TagPredicate.isNot((TagKey)DamageTypeTags.BYPASSES_INVULNERABILITY)))})).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(ResourceLocation.withDefaultNamespace((String)"enchantment.fire_protection"), Attributes.BURNING_TIME, (LevelBasedValue)LevelBasedValue.perLevel((float)-0.15f), AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).withEffect(EnchantmentEffectComponents.DAMAGE_PROTECTION, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)3.0f)), DamageSourceCondition.hasDamageSource((DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is((TagKey)DamageTypeTags.IS_FALL)).tag(TagPredicate.isNot((TagKey)DamageTypeTags.BYPASSES_INVULNERABILITY)))).withEffect(EnchantmentEffectComponents.DAMAGE_PROTECTION, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)2.0f)), DamageSourceCondition.hasDamageSource((DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is((TagKey)DamageTypeTags.IS_EXPLOSION)).tag(TagPredicate.isNot((TagKey)DamageTypeTags.BYPASSES_INVULNERABILITY)))).withEffect(EnchantmentEffectComponents.ATTRIBUTES, new EnchantmentAttributeEffect(ResourceLocation.withDefaultNamespace((String)"enchantment.blast_protection"), Attributes.EXPLOSION_KNOCKBACK_RESISTANCE, (LevelBasedValue)LevelBasedValue.perLevel((float)0.15f), AttributeModifier.Operation.ADD_VALUE)).withEffect(EnchantmentEffectComponents.DAMAGE_PROTECTION, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)2.0f)), DamageSourceCondition.hasDamageSource((DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is((TagKey)DamageTypeTags.IS_PROJECTILE)).tag(TagPredicate.isNot((TagKey)DamageTypeTags.BYPASSES_INVULNERABILITY)))).withEffect(EnchantmentEffectComponents.DAMAGE_PROTECTION, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)2.0f)), DamageSourceCondition.hasDamageSource((DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is(DamageTypeTagsPM.IS_MAGIC)).tag(TagPredicate.isNot((TagKey)DamageTypeTags.BYPASSES_INVULNERABILITY)))).withEffect(EnchantmentEffectComponents.DAMAGE_PROTECTION, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)1.0f)), DamageSourceCondition.hasDamageSource((DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().tag(TagPredicate.isNot((TagKey)DamageTypeTags.IS_FIRE)).tag(TagPredicate.isNot((TagKey)DamageTypeTags.IS_FALL)).tag(TagPredicate.isNot((TagKey)DamageTypeTags.IS_EXPLOSION)).tag(TagPredicate.isNot((TagKey)DamageTypeTags.IS_PROJECTILE)).tag(TagPredicate.isNot(DamageTypeTagsPM.IS_MAGIC)).tag(TagPredicate.isNot((TagKey)DamageTypeTags.BYPASSES_INVULNERABILITY)))));
        EnchantmentsPM.register(pContext, MANA_EFFICIENCY, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.MANA_EFFICIENCY_ENCHANTABLE), (HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.MANA_EFFICIENCY_ENCHANTABLE), (int)10, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)51, (int)10), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ANY})));
        EnchantmentsPM.register(pContext, SPELL_POWER, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.SPELL_POWER_ENCHANTABLE), (HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.SPELL_POWER_ENCHANTABLE), (int)2, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)10, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)35, (int)10), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND})));
        EnchantmentsPM.register(pContext, TREASURE, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.WAND_ENCHANTABLE), (HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.WAND_ENCHANTABLE), (int)2, (int)3, (Enchantment.Cost)Enchantment.dynamicCost((int)15, (int)9), (Enchantment.Cost)Enchantment.dynamicCost((int)65, (int)9), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withEffect(EnchantmentEffectComponents.EQUIPMENT_DROPS, EnchantmentTarget.ATTACKER, EnchantmentTarget.VICTIM, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)0.01f)), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.ATTACKER, (EntityPredicate.Builder)EntityPredicate.Builder.entity().entityType(EntityTypePredicate.of((EntityType)EntityType.PLAYER)))));
        EnchantmentsPM.register(pContext, BLUDGEONING, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.STAFF_ENCHANTABLE), (HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.STAFF_ENCHANTABLE), (int)10, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)1, (int)11), (Enchantment.Cost)Enchantment.dynamicCost((int)21, (int)11), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).exclusiveWith((HolderSet)enchantmentHolderGetter.getOrThrow(EnchantmentTags.DAMAGE_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)1.0f, (float)0.5f))));
        EnchantmentsPM.register(pContext, REVERBERATION, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTags.MINING_ENCHANTABLE), (int)1, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)10), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).exclusiveWith((HolderSet)enchantmentHolderGetter.getOrThrow(EnchantmentTagsPM.DIGGING_AREA_EXCLUSIVE)));
        EnchantmentsPM.register(pContext, BOUNTY, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.BOUNTY_ENCHANTABLE), (int)2, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)10), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})));
        EnchantmentsPM.register(pContext, DISINTEGRATION, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTags.MINING_ENCHANTABLE), (int)1, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)10), (int)8, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).exclusiveWith((HolderSet)enchantmentHolderGetter.getOrThrow(EnchantmentTagsPM.DIGGING_AREA_EXCLUSIVE)));
        EnchantmentsPM.register(pContext, VERDANT, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.HOE_ENCHANTABLE), (int)2, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)10), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})));
        EnchantmentsPM.register(pContext, LUCKY_STRIKE, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTags.MINING_LOOT_ENCHANTABLE), (int)2, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)10), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})));
        EnchantmentsPM.register(pContext, RENDING, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.RENDING_ENCHANTABLE), (int)2, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)10), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})).withEffect(EnchantmentEffectComponents.POST_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.VICTIM, (Object)new ApplyStackingMobEffect(EffectsPM.BLEEDING.getHolder(), (LevelBasedValue)LevelBasedValue.constant((float)120.0f), (LevelBasedValue)LevelBasedValue.constant((float)1.0f), (LevelBasedValue)LevelBasedValue.perLevel((float)1.0f))));
        EnchantmentsPM.register(pContext, SOULPIERCING, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.ARCHERY_ENCHANTABLE), (int)2, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)10), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})));
        EnchantmentsPM.register(pContext, ESSENCE_THIEF, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.ESSENCE_THIEF_ENCHANTABLE), (int)2, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)10), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND})));
        EnchantmentsPM.register(pContext, BULWARK, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.SHIELD_ENCHANTABLE), (int)2, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)10), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.OFFHAND})));
        EnchantmentsPM.register(pContext, MAGICK_PROTECTION, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTags.ARMOR_ENCHANTABLE), (HolderSet)itemHolderGetter.getOrThrow(ItemTags.ARMOR_ENCHANTABLE), (int)5, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)8), (Enchantment.Cost)Enchantment.dynamicCost((int)13, (int)8), (int)2, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.ARMOR})).exclusiveWith((HolderSet)enchantmentHolderGetter.getOrThrow(EnchantmentTags.ARMOR_EXCLUSIVE)).withEffect(EnchantmentEffectComponents.DAMAGE_PROTECTION, (Object)new AddValue((LevelBasedValue)LevelBasedValue.perLevel((float)2.0f)), DamageSourceCondition.hasDamageSource((DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().tag(TagPredicate.is(DamageTypeTagsPM.IS_MAGIC)).tag(TagPredicate.isNot((TagKey)DamageTypeTags.BYPASSES_INVULNERABILITY)))));
        EnchantmentsPM.register(pContext, GUILLOTINE, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTags.SHARP_WEAPON_ENCHANTABLE), (HolderSet)itemHolderGetter.getOrThrow(ItemTags.SHARP_WEAPON_ENCHANTABLE), (int)2, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)5, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)20, (int)10), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.MAINHAND})));
        EnchantmentsPM.register(pContext, PONDERING, Enchantment.enchantment((Enchantment.EnchantmentDefinition)Enchantment.definition((HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.PONDERING_ENCHANTABLE), (HolderSet)itemHolderGetter.getOrThrow(ItemTagsPM.PONDERING_ENCHANTABLE), (int)2, (int)5, (Enchantment.Cost)Enchantment.dynamicCost((int)10, (int)10), (Enchantment.Cost)Enchantment.dynamicCost((int)35, (int)10), (int)4, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.OFFHAND})));
    }

    private static void register(BootstrapContext<Enchantment> pContext, ResourceKey<Enchantment> pKey, Enchantment.Builder pBuilder) {
        pContext.register(pKey, (Object)pBuilder.build(pKey.location()));
    }

    private static ResourceKey<Enchantment> key(String pName) {
        return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceUtils.loc(pName));
    }
}

