/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.enchantments;

import com.verdantartifice.primalmagick.common.enchantments.EnchantmentsPM;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class EnchantmentHelperPM {
    public static int getEquippedEnchantmentLevel(LivingEntity entity, ResourceKey<Enchantment> enchantment) {
        Optional holderOpt = entity.level().holderLookup(Registries.ENCHANTMENT).get(enchantment);
        return holderOpt.map(enchantmentReference -> EnchantmentHelper.getEnchantmentLevel((Holder)enchantmentReference, (LivingEntity)entity)).orElse(0);
    }

    public static int getEnchantmentLevel(ItemStack stack, ResourceKey<Enchantment> enchantment, HolderLookup.Provider registries) {
        Optional holderOpt = registries.lookupOrThrow(Registries.ENCHANTMENT).get(enchantment);
        return holderOpt.map(enchantmentReference -> stack.getEnchantments().getLevel((Holder)enchantmentReference)).orElse(0);
    }

    public static boolean hasEnderport(LivingEntity entity) {
        return EnchantmentHelperPM.getEquippedEnchantmentLevel(entity, EnchantmentsPM.ENDERPORT) > 0;
    }

    public static boolean hasRegrowth(ItemStack stack, HolderLookup.Provider registries) {
        return EnchantmentHelperPM.getEnchantmentLevel(stack, EnchantmentsPM.REGROWTH, registries) > 0;
    }
}

