/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.effects;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;

public class FlyingEffect
extends MobEffect {
    public FlyingEffect(MobEffectCategory typeIn, int liquidColorIn) {
        super(typeIn, liquidColorIn);
    }

    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return pDuration <= 1;
    }

    public boolean applyEffectTick(LivingEntity pLivingEntity, int pAmplifier) {
        Level level = pLivingEntity.level();
        if (!level.isClientSide && pLivingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pLivingEntity;
            GameType type = player.gameMode.getGameModeForPlayer();
            boolean bl = player.getAbilities().mayfly = type == GameType.CREATIVE || type == GameType.SPECTATOR;
            if (!player.getAbilities().mayfly) {
                player.getAbilities().flying = false;
            }
            player.onUpdateAbilities();
        }
        return true;
    }

    public void onEffectStarted(LivingEntity pLivingEntity, int pAmplifier) {
        Level level = pLivingEntity.level();
        if (!level.isClientSide && pLivingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pLivingEntity;
            player.getAbilities().mayfly = true;
            player.onUpdateAbilities();
        }
        super.onEffectStarted(pLivingEntity, pAmplifier);
    }
}

