/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting.recipe_book;

import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBookManager;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.StackedComponentContents;
import com.verdantartifice.primalmagick.common.menus.base.IArcaneRecipeBookMenu;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.recipe_book.PlaceGhostArcaneRecipePacket;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.recipebook.PlaceRecipe;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPlaceArcaneRecipe<T extends RecipeInput, R extends Recipe<T>>
implements PlaceRecipe<Integer> {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final StackedComponentContents stackedContents = new StackedComponentContents();
    protected final IArcaneRecipeBookMenu<T, R> menu;
    protected Inventory inventory;
    protected RecipeHolder<R> activeRecipeHolder;

    public ServerPlaceArcaneRecipe(IArcaneRecipeBookMenu<T, R> menu) {
        this.menu = menu;
    }

    public void recipeClicked(ServerPlayer player, @Nullable RecipeHolder<R> recipeHolder, boolean shiftDown) {
        if (recipeHolder != null) {
            boolean inVanillaBook = player.getRecipeBook().contains(recipeHolder);
            boolean inArcaneBook = ArcaneRecipeBookManager.containsRecipe((Player)player, recipeHolder);
            if (inVanillaBook || inArcaneBook) {
                this.inventory = player.getInventory();
                if (this.testClearGrid() || player.isCreative()) {
                    this.stackedContents.clear();
                    player.getInventory().fillStackedContents((StackedContents)this.stackedContents);
                    this.menu.fillCraftSlotsStackedContents(this.stackedContents);
                    if (this.stackedContents.canCraft(recipeHolder.value(), null)) {
                        this.activeRecipeHolder = recipeHolder;
                        this.handleRecipeClicked(recipeHolder, shiftDown);
                    } else {
                        this.clearGrid();
                        PacketHandler.sendToPlayer(new PlaceGhostArcaneRecipePacket(player.containerMenu.containerId, recipeHolder), player);
                    }
                    player.getInventory().setChanged();
                }
            }
        }
    }

    protected void clearGrid() {
        for (int index = 0; index < this.menu.getSize(); ++index) {
            if (!this.menu.shouldMoveToInventory(index)) continue;
            ItemStack stack = this.menu.getSlot(index).getItem().copy();
            this.inventory.placeItemBackInInventory(stack, false);
            this.menu.getSlot(index).set(stack);
        }
        this.menu.clearCraftingContent();
    }

    protected void handleRecipeClicked(RecipeHolder<R> recipeHolder, boolean shiftDown) {
        boolean matches = this.menu.recipeMatches(recipeHolder);
        int i = this.stackedContents.getBiggestCraftableStack(recipeHolder, null);
        if (matches) {
            for (int index = 0; index < this.menu.getGridHeight() * this.menu.getGridWidth() + 1; ++index) {
                ItemStack stack;
                if (index == this.menu.getResultSlotIndex() || (stack = this.menu.getSlot(index).getItem()).isEmpty() || Math.min(i, stack.getMaxStackSize()) >= stack.getCount() + 1) continue;
                return;
            }
        }
        int stackSize = this.getStackSize(shiftDown, i, matches);
        IntArrayList list = new IntArrayList();
        if (this.stackedContents.canCraft(recipeHolder.value(), (IntList)list, stackSize)) {
            int curSize = stackSize;
            IntListIterator intListIterator = list.iterator();
            while (intListIterator.hasNext()) {
                int value = (Integer)intListIterator.next();
                int size = StackedContents.fromStackingIndex((int)value).getMaxStackSize();
                if (size >= curSize) continue;
                curSize = size;
            }
            if (this.stackedContents.canCraft(recipeHolder.value(), (IntList)list, curSize)) {
                this.clearGrid();
                this.placeRecipe(this.menu.getGridWidth(), this.menu.getGridHeight(), this.menu.getResultSlotIndex(), recipeHolder, (Iterator)list.iterator(), curSize);
            }
        }
    }

    public void addItemToSlot(Integer itemId, int slotIndex, int count, int p_135418_, int p_135419_) {
        Slot slot = this.menu.getSlot(slotIndex);
        ItemStack stack = StackedContents.fromStackingIndex((int)itemId);
        if (this.stackedContents.hasComponentData(itemId)) {
            stack.applyComponents(this.findMatchingData(itemId, stack));
        }
        if (!stack.isEmpty()) {
            for (int index = 0; index < count; ++index) {
                this.moveItemToGrid(slot, stack);
            }
        }
    }

    protected DataComponentMap findMatchingData(int itemId, ItemStack baseStack) {
        ItemStack workingStack = baseStack.copy();
        if (this.activeRecipeHolder != null && this.activeRecipeHolder.value() != null) {
            for (DataComponentMap data : this.stackedContents.getComponentData(itemId)) {
                for (Ingredient ing : this.activeRecipeHolder.value().getIngredients()) {
                    workingStack.applyComponents(data);
                    if (!ing.test(workingStack)) continue;
                    return data;
                }
            }
        }
        return DataComponentMap.EMPTY;
    }

    protected int getStackSize(boolean shiftDown, int stackSize, boolean matches) {
        int retVal = 1;
        if (shiftDown) {
            retVal = stackSize;
        } else if (matches) {
            retVal = 64;
            for (int index = 0; index < this.menu.getGridWidth() * this.menu.getGridHeight() + 1; ++index) {
                ItemStack stack;
                if (index == this.menu.getResultSlotIndex() || (stack = this.menu.getSlot(index).getItem()).isEmpty() || retVal <= stack.getCount()) continue;
                retVal = stack.getCount();
            }
            if (retVal < 64) {
                ++retVal;
            }
        }
        return retVal;
    }

    protected void moveItemToGrid(Slot slot, ItemStack stack) {
        ItemStack invStack;
        int index = this.inventory.findSlotMatchingUnusedItem(stack);
        if (index != -1 && !(invStack = this.inventory.getItem(index).copy()).isEmpty()) {
            if (invStack.getCount() > 1) {
                this.inventory.removeItem(index, 1);
            } else {
                this.inventory.removeItemNoUpdate(index);
            }
            invStack.setCount(1);
            if (slot.getItem().isEmpty()) {
                slot.set(invStack);
            } else {
                slot.getItem().grow(1);
            }
        }
    }

    protected boolean testClearGrid() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        int count = this.getAmountOfFreeSlotsInInventory();
        for (int index = 0; index < this.menu.getGridWidth() * this.menu.getGridHeight() + 1; ++index) {
            ItemStack stack;
            if (index == this.menu.getResultSlotIndex() || (stack = this.menu.getSlot(index).getItem().copy()).isEmpty()) continue;
            int slotIndex = this.inventory.getSlotWithRemainingSpace(stack);
            if (slotIndex == -1 && stackList.size() < count) {
                for (ItemStack listStack : stackList) {
                    if (!ItemStack.isSameItem((ItemStack)listStack, (ItemStack)stack) || listStack.getCount() == listStack.getMaxStackSize() || listStack.getCount() + stack.getCount() > listStack.getMaxStackSize()) continue;
                    listStack.grow(stack.getCount());
                    stack.setCount(0);
                    break;
                }
                if (stack.isEmpty()) continue;
                if (stackList.size() >= count) {
                    return false;
                }
                stackList.add(stack);
                continue;
            }
            if (slotIndex != -1) continue;
            return false;
        }
        return true;
    }

    protected int getAmountOfFreeSlotsInInventory() {
        int retVal = 0;
        for (ItemStack stack : this.inventory.items) {
            if (!stack.isEmpty()) continue;
            ++retVal;
        }
        return retVal;
    }
}

