/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting.recipe_book;

import com.verdantartifice.primalmagick.common.capabilities.IPlayerArcaneRecipeBook;
import com.verdantartifice.primalmagick.common.crafting.IArcaneRecipeBookItem;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;

public class ArcaneRecipeBookManager {
    private static final Set<UUID> SYNC_SET = ConcurrentHashMap.newKeySet();

    public static boolean isSyncScheduled(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        return SYNC_SET.remove(player.getUUID());
    }

    public static void scheduleSync(@Nullable Player player) {
        if (player != null) {
            SYNC_SET.add(player.getUUID());
        }
    }

    public static void addRecipes(Collection<RecipeHolder<?>> recipes, ServerPlayer serverPlayer) {
        Services.CAPABILITIES.arcaneRecipeBook((Player)serverPlayer).ifPresent(recipeBook -> {
            for (RecipeHolder recipe : recipes) {
                IArcaneRecipeBookItem arbi;
                Recipe patt0$temp = recipe.value();
                if (!(patt0$temp instanceof IArcaneRecipeBookItem) || (arbi = (IArcaneRecipeBookItem)patt0$temp).isArcaneSpecial()) continue;
                recipeBook.get().add(recipe);
                recipeBook.get().addHighlight(recipe);
            }
        });
        ArcaneRecipeBookManager.scheduleSync((Player)serverPlayer);
    }

    public static void removeRecipes(Collection<RecipeHolder<?>> recipes, ServerPlayer serverPlayer) {
        Services.CAPABILITIES.arcaneRecipeBook((Player)serverPlayer).ifPresent(recipeBook -> {
            for (RecipeHolder recipe : recipes) {
                recipeBook.get().remove(recipe);
            }
        });
        ArcaneRecipeBookManager.scheduleSync((Player)serverPlayer);
    }

    public static boolean containsRecipe(Player player, RecipeHolder<?> recipe) {
        IPlayerArcaneRecipeBook book = Services.CAPABILITIES.arcaneRecipeBook(player).orElse(null);
        return book != null && book.get().contains(recipe);
    }

    public static boolean syncRecipesWithResearch(ServerPlayer player) {
        IPlayerArcaneRecipeBook recipeBook = Services.CAPABILITIES.arcaneRecipeBook((Player)player).orElse(null);
        if (recipeBook == null) {
            return false;
        }
        recipeBook.get().clear();
        RecipeManager recipeManager = player.level().getRecipeManager();
        HashSet idsToAdd = new HashSet();
        ResearchEntries.stream(player.level().registryAccess()).filter(e -> e.key().isKnownBy((Player)player)).forEach(e -> idsToAdd.addAll(e.getKnownRecipeIds((Player)player)));
        ArcaneRecipeBookManager.addRecipes(idsToAdd.stream().map(id -> recipeManager.byKey(id).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet()), player);
        return true;
    }
}

