/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting.recipe_book;

import com.verdantartifice.primalmagick.common.crafting.IArcaneRecipeBookItem;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBookSettings;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBookType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ArcaneRecipeBook {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final Set<ResourceLocation> known = new HashSet<ResourceLocation>();
    protected final Set<ResourceLocation> highlight = new HashSet<ResourceLocation>();
    protected final ArcaneRecipeBookSettings settings = new ArcaneRecipeBookSettings();

    public void copyOverData(ArcaneRecipeBook other) {
        this.known.clear();
        this.highlight.clear();
        this.settings.replaceFrom(other.settings);
        this.known.addAll(other.known);
        this.highlight.addAll(other.highlight);
    }

    public void clear() {
        this.known.clear();
        this.highlight.clear();
        this.settings.clear();
    }

    public Set<ResourceLocation> getKnown() {
        return Collections.unmodifiableSet(this.known);
    }

    public Set<ResourceLocation> getHighlight() {
        return Collections.unmodifiableSet(this.highlight);
    }

    public static boolean isValid(RecipeHolder<?> recipe) {
        IArcaneRecipeBookItem arbi;
        Recipe recipe2 = recipe.value();
        return recipe2 instanceof IArcaneRecipeBookItem && !(arbi = (IArcaneRecipeBookItem)recipe2).isArcaneSpecial();
    }

    public void add(RecipeHolder<?> recipe) {
        if (ArcaneRecipeBook.isValid(recipe)) {
            this.add(recipe.id());
        }
    }

    protected void add(ResourceLocation loc) {
        this.known.add(loc);
    }

    public boolean contains(@Nullable RecipeHolder<?> recipe) {
        return recipe == null ? false : this.contains(recipe.id());
    }

    public boolean contains(ResourceLocation loc) {
        return this.known.contains(loc);
    }

    public void remove(RecipeHolder<?> recipe) {
        this.remove(recipe.id());
    }

    protected void remove(ResourceLocation loc) {
        this.known.remove(loc);
        this.highlight.remove(loc);
    }

    public boolean willHighlight(RecipeHolder<?> recipe) {
        return this.highlight.contains(recipe.id());
    }

    public void removeHighlight(RecipeHolder<?> recipe) {
        this.highlight.remove(recipe.id());
    }

    public void addHighlight(RecipeHolder<?> recipe) {
        this.highlight.add(recipe.id());
    }

    public boolean isOpen(ArcaneRecipeBookType type) {
        return this.settings.isOpen(type);
    }

    public void setOpen(ArcaneRecipeBookType type, boolean open) {
        this.settings.setOpen(type, open);
    }

    public boolean isFiltering(ArcaneRecipeBookType type) {
        return this.settings.isFiltering(type);
    }

    public void setFiltering(ArcaneRecipeBookType type, boolean filtering) {
        this.settings.setFiltering(type, filtering);
    }

    public void setBookSettings(ArcaneRecipeBookSettings settings) {
        this.settings.replaceFrom(settings);
    }

    public ArcaneRecipeBookSettings getBookSettings() {
        return this.settings.copy();
    }

    public void setBookSettings(ArcaneRecipeBookType type, boolean open, boolean filtering) {
        this.settings.setOpen(type, open);
        this.settings.setFiltering(type, filtering);
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        this.getBookSettings().write(tag);
        ListTag knownList = new ListTag();
        for (ResourceLocation loc : this.known) {
            knownList.add((Object)StringTag.valueOf((String)loc.toString()));
        }
        tag.put("Recipes", (Tag)knownList);
        ListTag highlightList = new ListTag();
        for (ResourceLocation loc : this.highlight) {
            highlightList.add((Object)StringTag.valueOf((String)loc.toString()));
        }
        tag.put("ToBeDisplayed", (Tag)highlightList);
        return tag;
    }

    public void fromNbt(CompoundTag tag, RecipeManager recipeManager) {
        this.clear();
        this.setBookSettings(ArcaneRecipeBookSettings.read(tag));
        this.loadRecipes(tag.getList("Recipes", 8), this::add, recipeManager);
        this.loadRecipes(tag.getList("ToBeDisplayed", 8), this::addHighlight, recipeManager);
    }

    protected void loadRecipes(ListTag tag, Consumer<RecipeHolder<?>> consumer, RecipeManager recipeManager) {
        for (int index = 0; index < tag.size(); ++index) {
            String locStr = tag.getString(index);
            try {
                ResourceLocation loc = ResourceLocation.parse((String)locStr);
                Optional recipeOpt = recipeManager.byKey(loc);
                recipeOpt.ifPresentOrElse(recipe -> consumer.accept((RecipeHolder<?>)recipe), () -> LOGGER.error("Failed to load unrecognized recipe: {}, removing", (Object)locStr));
                continue;
            }
            catch (ResourceLocationException e) {
                LOGGER.error("Failed to load improperly formatted recipe: {}, removing", (Object)locStr, (Object)e);
            }
        }
    }
}

