/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.theorycrafting.IWritingImplement;
import com.verdantartifice.primalmagick.platform.Services;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class WritableBookCraftingRecipe
extends CustomRecipe {
    protected static final RandomSource RANDOM = RandomSource.create();

    public WritableBookCraftingRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(CraftingInput pContainer, Level pLevel) {
        ItemStack penStack = ItemStack.EMPTY;
        ItemStack bookStack = ItemStack.EMPTY;
        for (int index = 0; index < pContainer.size(); ++index) {
            ItemStack stack = pContainer.getItem(index);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof IWritingImplement) {
                if (!penStack.isEmpty()) {
                    return false;
                }
                penStack = stack;
                continue;
            }
            if (stack.is(Items.BOOK)) {
                if (!bookStack.isEmpty()) {
                    return false;
                }
                bookStack = stack;
                continue;
            }
            return false;
        }
        return !penStack.isEmpty() && !bookStack.isEmpty();
    }

    public ItemStack assemble(CraftingInput pContainer, HolderLookup.Provider pRegistries) {
        ItemStack penStack = ItemStack.EMPTY;
        ItemStack bookStack = ItemStack.EMPTY;
        for (int index = 0; index < pContainer.size(); ++index) {
            ItemStack stack = pContainer.getItem(index);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof IWritingImplement) {
                penStack = stack;
                continue;
            }
            if (!stack.is(Items.BOOK)) continue;
            bookStack = stack;
        }
        if (!bookStack.isEmpty() && !penStack.isEmpty()) {
            return new ItemStack((ItemLike)Items.WRITABLE_BOOK);
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput pContainer) {
        NonNullList retVal = NonNullList.withSize((int)pContainer.size(), (Object)ItemStack.EMPTY);
        for (int index = 0; index < retVal.size(); ++index) {
            ItemStack inputStack = pContainer.getItem(index);
            if (Services.ITEMS.hasCraftingRemainingItem(inputStack)) {
                retVal.set(index, (Object)Services.ITEMS.getCraftingRemainingItem(inputStack));
                continue;
            }
            Item item = inputStack.getItem();
            if (!(item instanceof IWritingImplement)) continue;
            IWritingImplement pen = (IWritingImplement)item;
            ItemStack leftoverStack = inputStack.copyWithCount(1);
            if (pen.isDamagedOnUse()) {
                int newDamage = leftoverStack.getDamageValue() + 1;
                if (newDamage >= leftoverStack.getMaxDamage()) {
                    leftoverStack = ItemStack.EMPTY;
                } else {
                    leftoverStack.setDamageValue(newDamage);
                }
            }
            retVal.set(index, (Object)leftoverStack);
        }
        return retVal;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeSerializersPM.WRITABLE_BOOK_CRAFTING.get();
    }
}

