/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.items.armor.WardingModuleItem;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class WardingModuleApplicationRecipe
extends CustomRecipe {
    public WardingModuleApplicationRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput pContainer, Level pLevel) {
        ItemStack moduleStack = ItemStack.EMPTY;
        ItemStack armorStack = ItemStack.EMPTY;
        for (int index = 0; index < pContainer.size(); ++index) {
            ItemStack stack = pContainer.getItem(index);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof WardingModuleItem) {
                if (!moduleStack.isEmpty()) {
                    return false;
                }
                moduleStack = stack;
                continue;
            }
            if (stack.is(ItemTagsPM.WARDABLE_ARMOR)) {
                if (!armorStack.isEmpty()) {
                    return false;
                }
                armorStack = stack;
                continue;
            }
            return false;
        }
        return !moduleStack.isEmpty() && !armorStack.isEmpty();
    }

    public ItemStack assemble(CraftingInput pContainer, HolderLookup.Provider pRegistries) {
        ItemStack moduleStack = ItemStack.EMPTY;
        ItemStack armorStack = ItemStack.EMPTY;
        for (int index = 0; index < pContainer.size(); ++index) {
            ItemStack stack = pContainer.getItem(index);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof WardingModuleItem) {
                moduleStack = stack;
                continue;
            }
            if (!stack.is(ItemTagsPM.WARDABLE_ARMOR)) continue;
            armorStack = stack.copy();
        }
        if (armorStack.isEmpty()) {
            return armorStack;
        }
        Item item = moduleStack.getItem();
        if (item instanceof WardingModuleItem) {
            WardingModuleItem module = (WardingModuleItem)item;
            return module.applyWard(armorStack);
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeSerializersPM.WARDING_MODULE_APPLICATION.get();
    }
}

