/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.items.wands.SpellScrollItem;
import com.verdantartifice.primalmagick.common.wands.ISpellContainer;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class WandInscriptionRecipe
extends CustomRecipe {
    public WandInscriptionRecipe(CraftingBookCategory category) {
        super(category);
    }

    private static ItemStack getItem(CraftingInput inv, int index) {
        return index >= 0 && index < inv.size() ? inv.getItem(index) : ItemStack.EMPTY;
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        Item item;
        ItemStack wandStack = WandInscriptionRecipe.getItem(inv, 0);
        ItemStack scrollStack = WandInscriptionRecipe.getItem(inv, 1);
        if (!wandStack.isEmpty() && (item = wandStack.getItem()) instanceof ISpellContainer) {
            Item item2;
            ISpellContainer spellContainer = (ISpellContainer)item;
            if (!scrollStack.isEmpty() && (item2 = scrollStack.getItem()) instanceof SpellScrollItem) {
                SpellScrollItem scroll = (SpellScrollItem)item2;
                return spellContainer.canAddSpell(wandStack, scroll.getSpell(scrollStack));
            }
            return scrollStack.isEmpty();
        }
        return false;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        Item item;
        ItemStack wandStack = WandInscriptionRecipe.getItem(inv, 0);
        ItemStack scrollStack = WandInscriptionRecipe.getItem(inv, 1);
        if (!wandStack.isEmpty() && (item = wandStack.getItem()) instanceof ISpellContainer) {
            ItemStack retVal;
            Item item2;
            ISpellContainer spellContainer = (ISpellContainer)item;
            if (!scrollStack.isEmpty() && (item2 = scrollStack.getItem()) instanceof SpellScrollItem) {
                SpellScrollItem scroll = (SpellScrollItem)item2;
                retVal = wandStack.copy();
                if (spellContainer.addSpell(retVal, scroll.getSpell(scrollStack)) && spellContainer.setActiveSpellIndex(retVal, spellContainer.getSpellCount(retVal) - 1)) {
                    return retVal;
                }
                return ItemStack.EMPTY;
            }
            if (scrollStack.isEmpty()) {
                retVal = wandStack.copy();
                spellContainer.clearSpells(retVal);
                return retVal;
            }
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeSerializersPM.WAND_INSCRIPTION_SPECIAL.get();
    }
}

