/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.items.wands.IHasWandComponents;
import com.verdantartifice.primalmagick.common.items.wands.ModularWandItem;
import com.verdantartifice.primalmagick.common.items.wands.StaffCoreItem;
import com.verdantartifice.primalmagick.common.items.wands.WandCapItem;
import com.verdantartifice.primalmagick.common.items.wands.WandCoreItem;
import com.verdantartifice.primalmagick.common.items.wands.WandGemItem;
import com.verdantartifice.primalmagick.common.wands.IStaff;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class WandGlamourRecipe
extends CustomRecipe {
    public WandGlamourRecipe(CraftingBookCategory category) {
        super(category);
    }

    private static ItemStack getItem(CraftingInput inv, int index) {
        return index >= 0 && index < inv.size() ? inv.getItem(index) : ItemStack.EMPTY;
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        ItemStack wandStack = WandGlamourRecipe.getItem(inv, 0);
        ItemStack coreStack = WandGlamourRecipe.getItem(inv, 1);
        ItemStack capStack = WandGlamourRecipe.getItem(inv, 2);
        ItemStack gemStack = WandGlamourRecipe.getItem(inv, 3);
        boolean isStaff = wandStack.getItem() instanceof IStaff;
        return !wandStack.isEmpty() && wandStack.getItem() instanceof ModularWandItem && (coreStack.isEmpty() || isStaff && coreStack.getItem() instanceof StaffCoreItem || !isStaff && coreStack.getItem() instanceof WandCoreItem) && (capStack.isEmpty() || capStack.getItem() instanceof WandCapItem) && (gemStack.isEmpty() || gemStack.getItem() instanceof WandGemItem);
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        ItemStack wandStack = WandGlamourRecipe.getItem(inv, 0);
        ItemStack coreStack = WandGlamourRecipe.getItem(inv, 1);
        ItemStack capStack = WandGlamourRecipe.getItem(inv, 2);
        ItemStack gemStack = WandGlamourRecipe.getItem(inv, 3);
        ItemStack retVal = wandStack.copy();
        IHasWandComponents wandItem = (IHasWandComponents)retVal.getItem();
        Item item = coreStack.getItem();
        if (item instanceof WandCoreItem) {
            WandCoreItem wandCoreItem = (WandCoreItem)item;
            wandItem.setWandCoreAppearance(retVal, wandCoreItem.getWandCore());
        } else {
            item = coreStack.getItem();
            if (item instanceof StaffCoreItem) {
                StaffCoreItem staffCoreItem = (StaffCoreItem)item;
                wandItem.setWandCoreAppearance(retVal, staffCoreItem.getWandCore());
            } else {
                wandItem.setWandCoreAppearance(retVal, null);
            }
        }
        Item item2 = capStack.getItem();
        if (item2 instanceof WandCapItem) {
            WandCapItem capItem = (WandCapItem)item2;
            wandItem.setWandCapAppearance(retVal, capItem.getWandCap());
        } else {
            wandItem.setWandCapAppearance(retVal, null);
        }
        item2 = gemStack.getItem();
        if (item2 instanceof WandGemItem) {
            WandGemItem gemItem = (WandGemItem)item2;
            wandItem.setWandGemAppearance(retVal, gemItem.getWandGem());
        } else {
            wandItem.setWandGemAppearance(retVal, null);
        }
        return retVal;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 4;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeSerializersPM.WAND_GLAMOUR_SPECIAL.get();
    }
}

