/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.items.tools.AbstractTieredShieldItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class TieredShieldDecorationRecipe
extends CustomRecipe {
    public TieredShieldDecorationRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        ItemStack shieldStack = ItemStack.EMPTY;
        ItemStack bannerStack = ItemStack.EMPTY;
        for (int index = 0; index < inv.size(); ++index) {
            AbstractTieredShieldItem shieldItem;
            ItemStack stack = inv.getItem(index);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof BannerItem) {
                if (!bannerStack.isEmpty()) {
                    return false;
                }
                bannerStack = stack;
                continue;
            }
            Item item = stack.getItem();
            if (!(item instanceof AbstractTieredShieldItem && (shieldItem = (AbstractTieredShieldItem)item).canDecorate() && shieldStack.isEmpty())) {
                return false;
            }
            BannerPatternLayers layers = (BannerPatternLayers)stack.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY);
            if (!layers.layers().isEmpty()) {
                return false;
            }
            shieldStack = stack;
        }
        return !shieldStack.isEmpty() && !bannerStack.isEmpty();
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registries) {
        ItemStack shieldStack = ItemStack.EMPTY;
        ItemStack bannerStack = ItemStack.EMPTY;
        for (int index = 0; index < inv.size(); ++index) {
            AbstractTieredShieldItem shieldItem;
            ItemStack stack = inv.getItem(index);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof BannerItem) {
                bannerStack = stack;
                continue;
            }
            Item item = stack.getItem();
            if (!(item instanceof AbstractTieredShieldItem) || !(shieldItem = (AbstractTieredShieldItem)item).canDecorate()) continue;
            shieldStack = stack.copy();
        }
        if (shieldStack.isEmpty()) {
            return shieldStack;
        }
        shieldStack.set(DataComponents.BANNER_PATTERNS, (Object)((BannerPatternLayers)bannerStack.get(DataComponents.BANNER_PATTERNS)));
        shieldStack.set(DataComponents.BASE_COLOR, (Object)((BannerItem)bannerStack.getItem()).getColor());
        return shieldStack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeSerializersPM.TIERED_SHIELD_DECORATION.get();
    }
}

