/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.items.books.StaticBookItem;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import com.verdantartifice.primalmagick.platform.Services;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class StaticBookCloningRecipe
extends CustomRecipe {
    public StaticBookCloningRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(CraftingInput pContainer, Level pLevel) {
        int count = 0;
        ItemStack bookStack = ItemStack.EMPTY;
        for (int index = 0; index < pContainer.size(); ++index) {
            ItemStack slotStack = pContainer.getItem(index);
            if (slotStack.isEmpty()) continue;
            if (slotStack.is(ItemTagsPM.STATIC_BOOKS)) {
                if (!bookStack.isEmpty()) {
                    return false;
                }
                bookStack = slotStack;
                continue;
            }
            if (slotStack.is(Items.WRITABLE_BOOK)) {
                ++count;
                continue;
            }
            return false;
        }
        return !bookStack.isEmpty() && StaticBookItem.getBookId(bookStack).isPresent() && count > 0;
    }

    public ItemStack assemble(CraftingInput pContainer, HolderLookup.Provider pRegistries) {
        int count = 0;
        ItemStack originalStack = ItemStack.EMPTY;
        for (int index = 0; index < pContainer.size(); ++index) {
            ItemStack slotStack = pContainer.getItem(index);
            if (slotStack.isEmpty()) continue;
            if (slotStack.is(ItemTagsPM.STATIC_BOOKS)) {
                if (!originalStack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                originalStack = slotStack;
                continue;
            }
            if (slotStack.is(Items.WRITABLE_BOOK)) {
                ++count;
                continue;
            }
            return ItemStack.EMPTY;
        }
        if (!originalStack.isEmpty() && StaticBookItem.getBookId(originalStack).isPresent() && count > 0 && StaticBookItem.getGeneration(originalStack) < 2) {
            ItemStack copyStack = originalStack.copyWithCount(count);
            StaticBookItem.setGeneration(copyStack, StaticBookItem.getGeneration(originalStack) + 1);
            return copyStack;
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput pContainer) {
        NonNullList retVal = NonNullList.withSize((int)pContainer.size(), (Object)ItemStack.EMPTY);
        for (int index = 0; index < retVal.size(); ++index) {
            ItemStack inputStack = pContainer.getItem(index);
            if (Services.ITEMS.hasCraftingRemainingItem(inputStack)) {
                retVal.set(index, (Object)Services.ITEMS.getCraftingRemainingItem(inputStack));
                continue;
            }
            if (!(inputStack.getItem() instanceof StaticBookItem)) continue;
            retVal.set(index, (Object)inputStack.copyWithCount(1));
            break;
        }
        return retVal;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth >= 3 && pHeight >= 3;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeSerializersPM.STATIC_BOOK_CLONING.get();
    }
}

