/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.crafting.AbstractTagCraftingRecipe;
import com.verdantartifice.primalmagick.common.crafting.IShapelessRecipePM;
import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.util.StreamCodecUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class ShapelessTagRecipe
extends AbstractTagCraftingRecipe<CraftingInput>
implements IShapelessRecipePM<CraftingInput>,
CraftingRecipe {
    protected final CraftingBookCategory category;
    protected final NonNullList<Ingredient> recipeItems;
    protected final boolean isSimple;

    public ShapelessTagRecipe(String group, CraftingBookCategory category, TagKey<Item> outputTag, int outputAmount, NonNullList<Ingredient> items) {
        super(group, outputTag, outputAmount);
        this.category = category;
        this.recipeItems = items;
        this.isSimple = items.stream().allMatch(Services.INGREDIENTS::isSimple);
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.recipeItems;
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializersPM.CRAFTING_SHAPELESS_TAG.get();
    }

    public CraftingBookCategory category() {
        return this.category;
    }

    @Override
    public boolean isSimple() {
        return this.isSimple;
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessTagRecipe> {
        protected static final MapCodec<ShapelessTagRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(sar -> sar.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(sar -> sar.category), (App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("outputTag").forGetter(sar -> sar.outputTag), (App)Codec.INT.fieldOf("outputAmount").forGetter(sar -> sar.outputAmount), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            Object[] ingArray = (Ingredient[])ingredients.stream().filter(Predicate.not(Ingredient::isEmpty)).toArray(Ingredient[]::new);
            if (ingArray.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless arcane recipe");
            }
            if (ingArray.length > 9) {
                return DataResult.error(() -> "Too many ingredients for shapeless arcane recipe");
            }
            return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingArray));
        }, DataResult::success).forGetter(sar -> sar.recipeItems)).apply((Applicative)instance, ShapelessTagRecipe::new));

        public MapCodec<ShapelessTagRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapelessTagRecipe> streamCodec() {
            return StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);
        }

        private static ShapelessTagRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
            String group = pBuffer.readUtf();
            CraftingBookCategory category = (CraftingBookCategory)pBuffer.readEnum(CraftingBookCategory.class);
            int count = pBuffer.readVarInt();
            NonNullList ingredients = NonNullList.withSize((int)count, (Object)Ingredient.EMPTY);
            ingredients.replaceAll(ing -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer));
            TagKey resultTag = (TagKey)StreamCodecUtils.tagKey(Registries.ITEM).decode((Object)pBuffer);
            int resultAmount = pBuffer.readVarInt();
            return new ShapelessTagRecipe(group, category, (TagKey<Item>)resultTag, resultAmount, (NonNullList<Ingredient>)ingredients);
        }

        private static void toNetwork(RegistryFriendlyByteBuf pBuffer, ShapelessTagRecipe pRecipe) {
            pBuffer.writeUtf(pRecipe.group);
            pBuffer.writeEnum((Enum)pRecipe.category);
            pBuffer.writeVarInt(pRecipe.recipeItems.size());
            for (Ingredient ingredient : pRecipe.recipeItems) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)ingredient);
            }
            StreamCodecUtils.tagKey(Registries.ITEM).encode((Object)pBuffer, (Object)pRecipe.outputTag);
            pBuffer.writeVarInt(pRecipe.outputAmount);
        }
    }
}

