/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.crafting.AbstractTagCraftingRecipe;
import com.verdantartifice.primalmagick.common.crafting.IShapelessArcaneRecipePM;
import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.research.keys.ResearchDisciplineKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.util.StreamCodecUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class ShapelessArcaneTagRecipe
extends AbstractTagCraftingRecipe<CraftingInput>
implements IShapelessArcaneRecipePM {
    protected final Optional<AbstractRequirement<?>> requirement;
    protected final SourceList manaCosts;
    protected final NonNullList<Ingredient> recipeItems;
    protected final boolean isSimple;
    protected final Optional<Integer> baseExpertiseOverride;
    protected final Optional<Integer> bonusExpertiseOverride;
    protected final Optional<ResourceLocation> expertiseGroup;
    protected final Optional<ResearchDisciplineKey> disciplineOverride;

    public ShapelessArcaneTagRecipe(String group, TagKey<Item> outputTag, int outputAmount, NonNullList<Ingredient> items, Optional<AbstractRequirement<?>> requirement, SourceList manaCosts, Optional<Integer> baseExpertiseOverride, Optional<Integer> bonusExpertiseOverride, Optional<ResourceLocation> expertiseGroup, Optional<ResearchDisciplineKey> disciplineOverride) {
        super(group, outputTag, outputAmount);
        this.requirement = requirement;
        this.manaCosts = manaCosts;
        this.recipeItems = items;
        this.isSimple = items.stream().allMatch(Services.INGREDIENTS::isSimple);
        this.baseExpertiseOverride = baseExpertiseOverride;
        this.bonusExpertiseOverride = bonusExpertiseOverride;
        this.expertiseGroup = expertiseGroup;
        this.disciplineOverride = disciplineOverride;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.recipeItems;
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializersPM.ARCANE_CRAFTING_SHAPELESS_TAG.get();
    }

    @Override
    @NotNull
    public SourceList getManaCosts() {
        return this.manaCosts;
    }

    @Override
    public Optional<AbstractRequirement<?>> getRequirement() {
        return this.requirement;
    }

    @Override
    public boolean isSimple() {
        return this.isSimple;
    }

    @Override
    public int getExpertiseReward(RegistryAccess registryAccess) {
        return this.baseExpertiseOverride.orElseGet(() -> this.getResearchTier(registryAccess).map(tier -> tier.getDefaultExpertise()).orElse(0));
    }

    @Override
    public int getBonusExpertiseReward(RegistryAccess registryAccess) {
        return this.bonusExpertiseOverride.orElseGet(() -> this.getResearchTier(registryAccess).map(tier -> tier.getDefaultBonusExpertise()).orElse(0));
    }

    @Override
    public Optional<ResourceLocation> getExpertiseGroup() {
        return this.expertiseGroup;
    }

    @Override
    public Optional<ResearchDisciplineKey> getResearchDisciplineOverride() {
        return this.disciplineOverride;
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessArcaneTagRecipe> {
        public MapCodec<ShapelessArcaneTagRecipe> codec() {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(sar -> sar.group), (App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("outputTag").forGetter(sar -> sar.outputTag), (App)Codec.INT.fieldOf("outputAmount").forGetter(sar -> sar.outputAmount), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
                Object[] ingArray = (Ingredient[])ingredients.stream().filter(Predicate.not(Ingredient::isEmpty)).toArray(Ingredient[]::new);
                if (ingArray.length == 0) {
                    return DataResult.error(() -> "No ingredients for shapeless arcane recipe");
                }
                if (ingArray.length > 9) {
                    return DataResult.error(() -> "Too many ingredients for shapeless arcane recipe");
                }
                return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingArray));
            }, DataResult::success).forGetter(sar -> sar.recipeItems), (App)AbstractRequirement.dispatchCodec().optionalFieldOf("requirement").forGetter(sar -> sar.requirement), (App)SourceList.CODEC.optionalFieldOf("mana", (Object)SourceList.EMPTY).forGetter(sar -> sar.manaCosts), (App)Codec.INT.optionalFieldOf("baseExpertiseOverride").forGetter(r -> r.baseExpertiseOverride), (App)Codec.INT.optionalFieldOf("bonusExpertiseOverride").forGetter(r -> r.bonusExpertiseOverride), (App)ResourceLocation.CODEC.optionalFieldOf("expertiseGroup").forGetter(r -> r.expertiseGroup), (App)ResearchDisciplineKey.CODEC.codec().optionalFieldOf("disciplineOverride").forGetter(r -> r.disciplineOverride)).apply((Applicative)instance, ShapelessArcaneTagRecipe::new));
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapelessArcaneTagRecipe> streamCodec() {
            return StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);
        }

        private static ShapelessArcaneTagRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
            String group = pBuffer.readUtf();
            Optional<AbstractRequirement<?>> requirement = pBuffer.readBoolean() ? Optional.ofNullable((AbstractRequirement)AbstractRequirement.dispatchStreamCodec().decode((Object)pBuffer)) : Optional.empty();
            SourceList manaCosts = SourceList.fromNetwork((FriendlyByteBuf)pBuffer);
            int count = pBuffer.readVarInt();
            NonNullList ingredients = NonNullList.withSize((int)count, (Object)Ingredient.EMPTY);
            ingredients.replaceAll(ing -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer));
            Optional baseExpOverride = pBuffer.readOptional(b -> b.readVarInt());
            Optional bonusExpOverride = pBuffer.readOptional(b -> b.readVarInt());
            Optional expGroup = pBuffer.readOptional(b -> b.readResourceLocation());
            Optional discOverride = pBuffer.readOptional(ResearchDisciplineKey.STREAM_CODEC);
            TagKey resultTag = (TagKey)StreamCodecUtils.tagKey(Registries.ITEM).decode((Object)pBuffer);
            int resultAmount = pBuffer.readVarInt();
            return new ShapelessArcaneTagRecipe(group, (TagKey<Item>)resultTag, resultAmount, (NonNullList<Ingredient>)ingredients, requirement, manaCosts, baseExpOverride, bonusExpOverride, expGroup, discOverride);
        }

        private static void toNetwork(RegistryFriendlyByteBuf pBuffer, ShapelessArcaneTagRecipe pRecipe) {
            pBuffer.writeUtf(pRecipe.group);
            pRecipe.requirement.ifPresentOrElse(req -> {
                pBuffer.writeBoolean(true);
                AbstractRequirement.dispatchStreamCodec().encode((Object)pBuffer, req);
            }, () -> pBuffer.writeBoolean(false));
            SourceList.toNetwork((FriendlyByteBuf)pBuffer, pRecipe.manaCosts);
            pBuffer.writeVarInt(pRecipe.recipeItems.size());
            for (Ingredient ingredient : pRecipe.recipeItems) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)ingredient);
            }
            pBuffer.writeOptional(pRecipe.baseExpertiseOverride, (b, e) -> b.writeVarInt(e.intValue()));
            pBuffer.writeOptional(pRecipe.bonusExpertiseOverride, (b, e) -> b.writeVarInt(e.intValue()));
            pBuffer.writeOptional(pRecipe.expertiseGroup, (b, g) -> b.writeResourceLocation(g));
            pBuffer.writeOptional(pRecipe.disciplineOverride, ResearchDisciplineKey.STREAM_CODEC);
            StreamCodecUtils.tagKey(Registries.ITEM).encode((Object)pBuffer, (Object)pRecipe.outputTag);
            pBuffer.writeVarInt(pRecipe.outputAmount);
        }
    }
}

