/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.crafting.AbstractStackCraftingRecipe;
import com.verdantartifice.primalmagick.common.crafting.BlockIngredient;
import com.verdantartifice.primalmagick.common.crafting.IRitualRecipe;
import com.verdantartifice.primalmagick.common.crafting.IShapelessRecipePM;
import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.research.keys.ResearchDisciplineKey;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class RitualRecipe
extends AbstractStackCraftingRecipe<CraftingInput>
implements IShapelessRecipePM<CraftingInput>,
IRitualRecipe {
    public static final int MIN_INSTABILITY = 0;
    public static final int MAX_INSTABILITY = 10;
    protected final Optional<AbstractRequirement<?>> requirement;
    protected final SourceList manaCosts;
    protected final int instability;
    protected final NonNullList<Ingredient> recipeItems;
    protected final NonNullList<BlockIngredient> recipeProps;
    protected final boolean isSimple;
    protected final Optional<Integer> baseExpertiseOverride;
    protected final Optional<Integer> bonusExpertiseOverride;
    protected final Optional<ResourceLocation> expertiseGroup;
    protected final Optional<ResearchDisciplineKey> disciplineOverride;

    public RitualRecipe(String group, ItemStack output, NonNullList<Ingredient> items, NonNullList<BlockIngredient> props, Optional<AbstractRequirement<?>> requirement, SourceList manaCosts, int instability, Optional<Integer> baseExpertiseOverride, Optional<Integer> bonusExpertiseOverride, Optional<ResourceLocation> expertiseGroup, Optional<ResearchDisciplineKey> disciplineOverride) {
        super(group, output);
        this.requirement = requirement;
        this.manaCosts = manaCosts;
        this.instability = instability;
        this.recipeItems = items;
        this.recipeProps = props;
        this.isSimple = items.stream().allMatch(Services.INGREDIENTS::isSimple);
        this.baseExpertiseOverride = baseExpertiseOverride;
        this.bonusExpertiseOverride = bonusExpertiseOverride;
        this.expertiseGroup = expertiseGroup;
        this.disciplineOverride = disciplineOverride;
    }

    @Override
    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.recipeItems;
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializersPM.RITUAL.get();
    }

    @Override
    public Optional<AbstractRequirement<?>> getRequirement() {
        return this.requirement;
    }

    @Override
    @NotNull
    public SourceList getManaCosts() {
        return this.manaCosts;
    }

    @Override
    public NonNullList<BlockIngredient> getProps() {
        return this.recipeProps;
    }

    @Override
    public int getInstability() {
        return this.instability;
    }

    @Override
    public boolean isSimple() {
        return this.isSimple;
    }

    @Override
    public int getExpertiseReward(RegistryAccess registryAccess) {
        return this.baseExpertiseOverride.orElseGet(() -> this.getResearchTier(registryAccess).map(tier -> tier.getDefaultExpertise()).orElse(0));
    }

    @Override
    public int getBonusExpertiseReward(RegistryAccess registryAccess) {
        return this.bonusExpertiseOverride.orElseGet(() -> this.getResearchTier(registryAccess).map(tier -> tier.getDefaultBonusExpertise()).orElse(0));
    }

    @Override
    public Optional<ResourceLocation> getExpertiseGroup() {
        return this.expertiseGroup;
    }

    @Override
    public Optional<ResearchDisciplineKey> getResearchDisciplineOverride() {
        return this.disciplineOverride;
    }

    public static class Serializer
    implements RecipeSerializer<RitualRecipe> {
        public MapCodec<RitualRecipe> codec() {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(rr -> rr.group), (App)ItemStack.CODEC.fieldOf("result").forGetter(rr -> rr.output), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
                Object[] ingArray = (Ingredient[])ingredients.stream().filter(Predicate.not(Ingredient::isEmpty)).toArray(Ingredient[]::new);
                if (ingArray.length == 0) {
                    return DataResult.error(() -> "No offerings for ritual recipe");
                }
                return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingArray));
            }, DataResult::success).forGetter(rr -> rr.recipeItems), (App)BlockIngredient.CODEC_NONEMPTY.listOf().fieldOf("props").flatXmap(ingredients -> {
                Object[] ingArray = (BlockIngredient[])ingredients.stream().filter(Predicate.not(BlockIngredient::isEmpty)).toArray(BlockIngredient[]::new);
                if (ingArray.length == 0) {
                    return DataResult.error(() -> "No props for ritual recipe");
                }
                return DataResult.success((Object)NonNullList.of((Object)BlockIngredient.EMPTY, (Object[])ingArray));
            }, DataResult::success).forGetter(rr -> rr.recipeProps), (App)AbstractRequirement.dispatchCodec().optionalFieldOf("requirement").forGetter(rr -> rr.requirement), (App)SourceList.CODEC.optionalFieldOf("mana", (Object)SourceList.EMPTY).forGetter(rr -> rr.manaCosts), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("instability").forGetter(rr -> rr.instability), (App)Codec.INT.optionalFieldOf("baseExpertiseOverride").forGetter(r -> r.baseExpertiseOverride), (App)Codec.INT.optionalFieldOf("bonusExpertiseOverride").forGetter(r -> r.bonusExpertiseOverride), (App)ResourceLocation.CODEC.optionalFieldOf("expertiseGroup").forGetter(r -> r.expertiseGroup), (App)ResearchDisciplineKey.CODEC.codec().optionalFieldOf("disciplineOverride").forGetter(r -> r.disciplineOverride)).apply((Applicative)instance, RitualRecipe::new));
        }

        public StreamCodec<RegistryFriendlyByteBuf, RitualRecipe> streamCodec() {
            return StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);
        }

        private static RitualRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf(Short.MAX_VALUE);
            Optional<AbstractRequirement<?>> requirement = buffer.readBoolean() ? Optional.ofNullable((AbstractRequirement)AbstractRequirement.dispatchStreamCodec().decode((Object)buffer)) : Optional.empty();
            int instability = buffer.readVarInt();
            SourceList manaCosts = SourceList.fromNetwork((FriendlyByteBuf)buffer);
            int ingredientCount = buffer.readVarInt();
            NonNullList ingredients = NonNullList.withSize((int)ingredientCount, (Object)Ingredient.EMPTY);
            ingredients.replaceAll(ing -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            int propCount = buffer.readVarInt();
            NonNullList props = NonNullList.withSize((int)propCount, (Object)BlockIngredient.EMPTY);
            props.replaceAll(prop -> (BlockIngredient)BlockIngredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            Optional baseExpOverride = buffer.readOptional(b -> b.readVarInt());
            Optional bonusExpOverride = buffer.readOptional(b -> b.readVarInt());
            Optional expGroup = buffer.readOptional(b -> b.readResourceLocation());
            Optional discOverride = buffer.readOptional(ResearchDisciplineKey.STREAM_CODEC);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new RitualRecipe(group, result, (NonNullList<Ingredient>)ingredients, (NonNullList<BlockIngredient>)props, requirement, manaCosts, instability, baseExpOverride, bonusExpOverride, expGroup, discOverride);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, RitualRecipe recipe) {
            buffer.writeUtf(recipe.group);
            recipe.requirement.ifPresentOrElse(req -> {
                buffer.writeBoolean(true);
                AbstractRequirement.dispatchStreamCodec().encode((Object)buffer, req);
            }, () -> buffer.writeBoolean(false));
            buffer.writeVarInt(recipe.instability);
            SourceList.toNetwork((FriendlyByteBuf)buffer, recipe.manaCosts);
            buffer.writeVarInt(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            buffer.writeVarInt(recipe.recipeProps.size());
            for (BlockIngredient prop : recipe.recipeProps) {
                BlockIngredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)prop);
            }
            buffer.writeOptional(recipe.baseExpertiseOverride, (b, e) -> b.writeVarInt(e.intValue()));
            buffer.writeOptional(recipe.bonusExpertiseOverride, (b, e) -> b.writeVarInt(e.intValue()));
            buffer.writeOptional(recipe.expertiseGroup, (b, g) -> b.writeResourceLocation(g));
            buffer.writeOptional(recipe.disciplineOverride, ResearchDisciplineKey.STREAM_CODEC);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
        }
    }
}

