/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.verdantartifice.primalmagick.common.crafting.IArcaneRecipe;
import com.verdantartifice.primalmagick.common.crafting.IConcoctingRecipe;
import com.verdantartifice.primalmagick.common.crafting.IDissolutionRecipe;
import com.verdantartifice.primalmagick.common.crafting.IRitualRecipe;
import com.verdantartifice.primalmagick.common.crafting.IRunecarvingRecipe;
import com.verdantartifice.primalmagick.common.registries.IRegistryItem;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.function.Supplier;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;

public class RecipeTypesPM {
    public static final IRegistryItem<RecipeType<?>, RecipeType<IArcaneRecipe>> ARCANE_CRAFTING = RecipeTypesPM.register("arcane_crafting", () -> RecipeTypesPM.simple("arcane_crafting"));
    public static final IRegistryItem<RecipeType<?>, RecipeType<IRitualRecipe>> RITUAL = RecipeTypesPM.register("ritual", () -> RecipeTypesPM.simple("ritual"));
    public static final IRegistryItem<RecipeType<?>, RecipeType<IRunecarvingRecipe>> RUNECARVING = RecipeTypesPM.register("runecarving", () -> RecipeTypesPM.simple("runecarving"));
    public static final IRegistryItem<RecipeType<?>, RecipeType<IConcoctingRecipe>> CONCOCTING = RecipeTypesPM.register("concocting", () -> RecipeTypesPM.simple("concocting"));
    public static final IRegistryItem<RecipeType<?>, RecipeType<IDissolutionRecipe>> DISSOLUTION = RecipeTypesPM.register("dissolution", () -> RecipeTypesPM.simple("dissolution"));

    public static void init() {
        Services.RECIPE_TYPES_REGISTRY.init();
    }

    private static <T extends Recipe<?>> IRegistryItem<RecipeType<?>, RecipeType<T>> register(String name, Supplier<RecipeType<T>> supplier) {
        return Services.RECIPE_TYPES_REGISTRY.register(name, supplier);
    }

    private static <T extends Recipe<?>> RecipeType<T> simple(String name) {
        final String locStr = ResourceUtils.loc(name).toString();
        return new RecipeType<T>(){

            public String toString() {
                return locStr;
            }
        };
    }
}

