/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.verdantartifice.primalmagick.platform.Services;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;

public interface IShapelessRecipePM<T extends RecipeInput>
extends Recipe<T> {
    public boolean isSimple();

    default public boolean matches(T input, Level worldIn) {
        StackedContents helper = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int count = 0;
        for (int index = 0; index < input.size(); ++index) {
            ItemStack stack = input.getItem(index);
            if (stack.isEmpty()) continue;
            ++count;
            if (this.isSimple()) {
                helper.accountStack(stack, 1);
                continue;
            }
            inputs.add(stack);
        }
        return count == this.getIngredients().size() && (this.isSimple() ? helper.canCraft((Recipe)this, null) : Services.RECIPES.findMatches(inputs, this.getIngredients()) != null);
    }

    default public ItemStack assemble(T pInput, HolderLookup.Provider pRegistries) {
        return this.getResultItem(pRegistries).copy();
    }

    default public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return pWidth * pHeight >= this.getIngredients().size();
    }
}

