/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.verdantartifice.primalmagick.common.crafting.IHasRequirement;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.ResearchTier;
import com.verdantartifice.primalmagick.common.research.keys.AbstractResearchKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchDisciplineKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;

public interface IHasExpertise
extends IHasRequirement {
    public int getExpertiseReward(RegistryAccess var1);

    public int getBonusExpertiseReward(RegistryAccess var1);

    default public boolean hasExpertiseReward(RegistryAccess registryAccess) {
        return this.getExpertiseReward(registryAccess) > 0 || this.getBonusExpertiseReward(registryAccess) > 0;
    }

    public Optional<ResourceLocation> getExpertiseGroup();

    default public Optional<Component> getExpertiseGroupDescription() {
        return this.getExpertiseGroup().map(loc -> Component.translatable((String)Util.makeDescriptionId((String)"expertise_group", (ResourceLocation)loc)));
    }

    default public Optional<ResearchTier> getResearchTier(RegistryAccess registryAccess) {
        return this.getRequirement().flatMap(req -> req.getResearchTier(registryAccess));
    }

    public Optional<ResearchDisciplineKey> getResearchDisciplineOverride();

    default public Optional<ResearchDisciplineKey> getResearchDiscipline(RegistryAccess registryAccess, ResourceLocation recipeId) {
        return this.getResearchDisciplineOverride().or(() -> this.getRequirement().flatMap(req -> {
            HashSet foundDisciplines = new HashSet();
            for (AbstractResearchKey<?> rawKey : req.streamKeys().toList()) {
                ResearchEntryKey entryKey;
                ResearchEntry entry;
                if (!(rawKey instanceof ResearchEntryKey) || (entry = ResearchEntries.getEntry(registryAccess, entryKey = (ResearchEntryKey)rawKey)) == null) continue;
                entry.disciplineKeyOpt().ifPresent(foundDisciplines::add);
            }
            if (foundDisciplines.size() > 1) {
                LogManager.getLogger().warn("Multiple disciplines found for recipe {}", (Object)recipeId);
            }
            return foundDisciplines.stream().findFirst();
        }));
    }
}

