/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.crafting.AbstractTagCraftingRecipe;
import com.verdantartifice.primalmagick.common.crafting.IDissolutionRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.util.StreamCodecUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class DissolutionTagRecipe
extends AbstractTagCraftingRecipe<SingleRecipeInput>
implements IDissolutionRecipe {
    protected final Ingredient ingredient;
    protected final SourceList manaCosts;

    public DissolutionTagRecipe(String group, TagKey<Item> recipeOutputTag, int recipeOutputAmount, Ingredient ingredient, SourceList manaCosts) {
        super(group, recipeOutputTag, recipeOutputAmount);
        this.ingredient = ingredient;
        this.manaCosts = manaCosts;
    }

    public boolean matches(SingleRecipeInput inv, Level level) {
        return this.ingredient.test(inv.getItem(0));
    }

    public ItemStack assemble(SingleRecipeInput inv, HolderLookup.Provider registries) {
        return this.getResultItem(registries).copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.ingredient});
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializersPM.DISSOLUTION_TAG.get();
    }

    @Override
    @NotNull
    public SourceList getManaCosts() {
        return this.manaCosts;
    }

    public static class Serializer
    implements RecipeSerializer<DissolutionTagRecipe> {
        protected static final MapCodec<DissolutionTagRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(dr -> dr.group), (App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("outputTag").forGetter(dr -> dr.outputTag), (App)Codec.INT.fieldOf("outputAmount").forGetter(dr -> dr.outputAmount), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(dr -> dr.ingredient), (App)SourceList.CODEC.optionalFieldOf("mana", (Object)SourceList.EMPTY).forGetter(dr -> dr.manaCosts)).apply((Applicative)instance, DissolutionTagRecipe::new));
        protected static final StreamCodec<RegistryFriendlyByteBuf, DissolutionTagRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, r -> r.group, StreamCodecUtils.tagKey(Registries.ITEM), r -> r.outputTag, (StreamCodec)ByteBufCodecs.VAR_INT, r -> r.outputAmount, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.ingredient, SourceList.STREAM_CODEC, r -> r.manaCosts, DissolutionTagRecipe::new);

        public MapCodec<DissolutionTagRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DissolutionTagRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

