/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.crafting.AbstractStackCraftingRecipe;
import com.verdantartifice.primalmagick.common.crafting.IDissolutionRecipe;
import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class DissolutionRecipe
extends AbstractStackCraftingRecipe<SingleRecipeInput>
implements IDissolutionRecipe {
    protected final Ingredient ingredient;
    protected final SourceList manaCosts;

    public DissolutionRecipe(String group, ItemStack result, Ingredient ingredient, SourceList manaCosts) {
        super(group, result);
        this.ingredient = ingredient;
        this.manaCosts = manaCosts;
    }

    public boolean matches(SingleRecipeInput inv, Level level) {
        return this.ingredient.test(inv.getItem(0));
    }

    public ItemStack assemble(SingleRecipeInput inv, HolderLookup.Provider registries) {
        return this.getResultItem(registries).copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.ingredient});
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializersPM.DISSOLUTION.get();
    }

    @Override
    @NotNull
    public SourceList getManaCosts() {
        return this.manaCosts;
    }

    public static class Serializer
    implements RecipeSerializer<DissolutionRecipe> {
        protected static final MapCodec<DissolutionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(dr -> dr.group), (App)ItemStack.CODEC.fieldOf("result").forGetter(dr -> dr.output), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(dr -> dr.ingredient), (App)SourceList.CODEC.optionalFieldOf("mana", (Object)SourceList.EMPTY).forGetter(dr -> dr.manaCosts)).apply((Applicative)instance, DissolutionRecipe::new));
        protected static final StreamCodec<RegistryFriendlyByteBuf, DissolutionRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, r -> r.group, (StreamCodec)ItemStack.STREAM_CODEC, r -> r.output, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.ingredient, SourceList.STREAM_CODEC, r -> r.manaCosts, DissolutionRecipe::new);

        public MapCodec<DissolutionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DissolutionRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

