/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.crafting.AbstractStackCraftingRecipe;
import com.verdantartifice.primalmagick.common.crafting.IConcoctingRecipe;
import com.verdantartifice.primalmagick.common.crafting.IShapelessRecipePM;
import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class ConcoctingRecipe
extends AbstractStackCraftingRecipe<CraftingInput>
implements IShapelessRecipePM<CraftingInput>,
IConcoctingRecipe {
    protected final Optional<AbstractRequirement<?>> requirement;
    protected final SourceList manaCosts;
    protected final NonNullList<Ingredient> recipeItems;
    protected final boolean isSimple;

    public ConcoctingRecipe(String group, ItemStack output, NonNullList<Ingredient> items, Optional<AbstractRequirement<?>> requirement, SourceList manaCosts) {
        super(group, output);
        this.requirement = requirement;
        this.manaCosts = manaCosts;
        this.recipeItems = items;
        this.isSimple = items.stream().allMatch(Services.INGREDIENTS::isSimple);
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.recipeItems;
    }

    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializersPM.CONCOCTING.get();
    }

    @Override
    @NotNull
    public SourceList getManaCosts() {
        return this.manaCosts;
    }

    @Override
    public Optional<AbstractRequirement<?>> getRequirement() {
        return this.requirement;
    }

    @Override
    public boolean isSimple() {
        return this.isSimple;
    }

    public static class Serializer
    implements RecipeSerializer<ConcoctingRecipe> {
        public MapCodec<ConcoctingRecipe> codec() {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(sar -> sar.group), (App)ItemStack.CODEC.fieldOf("result").forGetter(sar -> sar.output), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
                Object[] ingArray = (Ingredient[])ingredients.stream().filter(Predicate.not(Ingredient::isEmpty)).toArray(Ingredient[]::new);
                if (ingArray.length == 0) {
                    return DataResult.error(() -> "No ingredients for concocting recipe");
                }
                if (ingArray.length > 9) {
                    return DataResult.error(() -> "Too many ingredients for concocting recipe");
                }
                return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingArray));
            }, DataResult::success).forGetter(sar -> sar.recipeItems), (App)AbstractRequirement.dispatchCodec().optionalFieldOf("requirement").forGetter(sar -> sar.requirement), (App)SourceList.CODEC.optionalFieldOf("mana", (Object)SourceList.EMPTY).forGetter(sar -> sar.manaCosts)).apply((Applicative)instance, ConcoctingRecipe::new));
        }

        public StreamCodec<RegistryFriendlyByteBuf, ConcoctingRecipe> streamCodec() {
            return StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);
        }

        private static ConcoctingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            Optional<AbstractRequirement<?>> requirement = buffer.readBoolean() ? Optional.ofNullable((AbstractRequirement)AbstractRequirement.dispatchStreamCodec().decode((Object)buffer)) : Optional.empty();
            SourceList manaCosts = SourceList.fromNetwork((FriendlyByteBuf)buffer);
            int count = buffer.readVarInt();
            NonNullList ingredients = NonNullList.withSize((int)count, (Object)Ingredient.EMPTY);
            ingredients.replaceAll(ing -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new ConcoctingRecipe(group, result, (NonNullList<Ingredient>)ingredients, requirement, manaCosts);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, ConcoctingRecipe recipe) {
            buffer.writeUtf(recipe.group);
            recipe.requirement.ifPresentOrElse(req -> {
                buffer.writeBoolean(true);
                AbstractRequirement.dispatchStreamCodec().encode((Object)buffer, req);
            }, () -> buffer.writeBoolean(false));
            SourceList.toNetwork((FriendlyByteBuf)buffer, recipe.manaCosts);
            buffer.writeVarInt(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.output);
        }
    }
}

