/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.util.CodecUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class BlockIngredient
implements Predicate<Block> {
    public static final BlockIngredient EMPTY = new BlockIngredient(Stream.empty());
    public static final Codec<BlockIngredient> CODEC = BlockIngredient.codec(true);
    public static final Codec<BlockIngredient> CODEC_NONEMPTY = BlockIngredient.codec(false);
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockIngredient> CONTENTS_STREAM_CODEC = StreamCodec.of(BlockIngredient::toNetwork, BlockIngredient::fromNetwork);
    protected final Value[] acceptedBlocks;
    protected Block[] matchingBlocks = null;

    protected BlockIngredient(Stream<? extends Value> blockLists) {
        this.acceptedBlocks = (Value[])blockLists.toArray(Value[]::new);
    }

    private BlockIngredient(Value[] values) {
        this.acceptedBlocks = values;
    }

    public Block[] getMatchingBlocks() {
        this.determineMatchingBlocks();
        return this.matchingBlocks;
    }

    protected void determineMatchingBlocks() {
        if (this.matchingBlocks == null) {
            this.matchingBlocks = (Block[])Arrays.stream(this.acceptedBlocks).flatMap(blockList -> blockList.getBlocks().stream()).distinct().toArray(Block[]::new);
        }
    }

    @Override
    public boolean test(@Nullable Block testBlock) {
        if (testBlock == null) {
            return false;
        }
        this.determineMatchingBlocks();
        for (Block block : this.matchingBlocks) {
            if (testBlock != block) continue;
            return true;
        }
        return false;
    }

    private static void toNetwork(RegistryFriendlyByteBuf buf, BlockIngredient ing) {
        ing.determineMatchingBlocks();
        buf.writeVarInt(ing.matchingBlocks.length);
        for (int index = 0; index < ing.matchingBlocks.length; ++index) {
            buf.writeResourceLocation(Services.BLOCKS_REGISTRY.getKey(ing.matchingBlocks[index]));
        }
    }

    public boolean isEmpty() {
        return this.acceptedBlocks.length == 0;
    }

    public boolean hasNoMatchingBlocks() {
        return this.acceptedBlocks.length == 0 && (this.matchingBlocks == null || this.matchingBlocks.length == 0);
    }

    public Ingredient asIngredient() {
        return Ingredient.of((ItemLike[])((ItemLike[])Arrays.stream(this.acceptedBlocks).flatMap(ibl -> ibl.getBlocks().stream()).toArray(ItemLike[]::new)));
    }

    protected static BlockIngredient fromBlockListStream(Stream<? extends Value> stream) {
        BlockIngredient ing = new BlockIngredient(stream);
        return ing.acceptedBlocks.length == 0 ? EMPTY : ing;
    }

    public static BlockIngredient fromBlocks(Block ... blocks) {
        return BlockIngredient.fromBlockListStream(Arrays.stream(blocks).map(b -> new SingleBlockValue((Block)b)));
    }

    public static BlockIngredient fromTag(TagKey<Block> tag) {
        return BlockIngredient.fromBlockListStream(Stream.of(new TagValue(tag)));
    }

    private static BlockIngredient fromNetwork(RegistryFriendlyByteBuf buf) {
        int size = buf.readVarInt();
        return BlockIngredient.fromBlockListStream(Stream.generate(() -> {
            ResourceLocation loc = buf.readResourceLocation();
            return new SingleBlockValue((Block)Services.BLOCKS_REGISTRY.get(loc));
        }).limit(size));
    }

    private static Codec<BlockIngredient> codec(boolean allowEmpty) {
        Codec innerCodec = Codec.list(Value.CODEC).comapFlatMap(valueList -> !allowEmpty && valueList.size() < 1 ? DataResult.error(() -> "Block array cannot be empty, at least one block must be defined") : DataResult.success((Object)((Value[])valueList.toArray(Value[]::new))), List::of);
        return Codec.either((Codec)innerCodec, Value.CODEC).flatComapMap(either -> (BlockIngredient)either.map(BlockIngredient::new, val -> new BlockIngredient(new Value[]{val})), ing -> {
            if (ing.acceptedBlocks.length == 1) {
                return DataResult.success((Object)Either.right((Object)ing.acceptedBlocks[0]));
            }
            return ing.acceptedBlocks.length == 0 && !allowEmpty ? DataResult.error(() -> "Block array cannot be empty, at least one block must be defined") : DataResult.success((Object)Either.left((Object)ing.acceptedBlocks));
        });
    }

    protected static interface Value {
        public static final Codec<Value> CODEC = Codec.xor(SingleBlockValue.CODEC, TagValue.CODEC).xmap(either -> (Value)either.map(l -> l, r -> r), val -> {
            if (val instanceof SingleBlockValue) {
                SingleBlockValue sbv = (SingleBlockValue)val;
                return Either.left((Object)sbv);
            }
            if (val instanceof TagValue) {
                TagValue tv = (TagValue)val;
                return Either.right((Object)tv);
            }
            throw new UnsupportedOperationException("This is neither a single block value nor a tag value");
        });

        public Collection<Block> getBlocks();
    }

    protected record TagValue(TagKey<Block> tag) implements Value
    {
        protected static final Codec<TagValue> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.BLOCK).fieldOf("tag").forGetter(tl -> tl.tag)).apply((Applicative)instance, TagValue::new));

        @Override
        public Collection<Block> getBlocks() {
            ArrayList<Block> retVal = new ArrayList<Block>();
            Services.BLOCKS_REGISTRY.getTag(this.tag).forEach(retVal::add);
            return retVal;
        }
    }

    protected record SingleBlockValue(Block block) implements Value
    {
        protected static final Codec<SingleBlockValue> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.BLOCK_NONAIR_CODEC.fieldOf("block").forGetter(sbl -> sbl.block)).apply((Applicative)instance, SingleBlockValue::new));

        @Override
        public Collection<Block> getBlocks() {
            return Collections.singleton(this.block);
        }
    }
}

