/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.verdantartifice.primalmagick.common.crafting.RecipeSerializersPM;
import com.verdantartifice.primalmagick.common.items.essence.EssenceItem;
import com.verdantartifice.primalmagick.common.items.tools.ManaOrbItem;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.tags.ItemTagsPM;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AttuneManaOrbRecipe
extends CustomRecipe {
    public AttuneManaOrbRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(@NotNull CraftingInput craftingInput, @NotNull Level level) {
        ItemStack orbStack = ItemStack.EMPTY;
        ItemStack dustStack = ItemStack.EMPTY;
        for (int index = 0; index < craftingInput.size(); ++index) {
            ItemStack slotStack = craftingInput.getItem(index);
            if (slotStack.isEmpty()) continue;
            if (slotStack.getItem() instanceof ManaOrbItem) {
                if (!orbStack.isEmpty()) {
                    return false;
                }
                orbStack = slotStack;
                continue;
            }
            if (slotStack.is(ItemTagsPM.ESSENCES_DUSTS)) {
                if (!dustStack.isEmpty()) {
                    return false;
                }
                dustStack = slotStack;
                continue;
            }
            return false;
        }
        return !orbStack.isEmpty();
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput craftingInput, @NotNull HolderLookup.Provider provider) {
        ItemStack itemStack;
        ItemStack orbStack = ItemStack.EMPTY;
        ItemStack dustStack = ItemStack.EMPTY;
        for (int index = 0; index < craftingInput.size(); ++index) {
            ItemStack slotStack = craftingInput.getItem(index);
            if (slotStack.isEmpty()) continue;
            if (slotStack.getItem() instanceof ManaOrbItem) {
                if (!orbStack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                orbStack = slotStack;
                continue;
            }
            if (slotStack.is(ItemTagsPM.ESSENCES_DUSTS)) {
                if (!dustStack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                dustStack = slotStack;
                continue;
            }
            return ItemStack.EMPTY;
        }
        if (!orbStack.isEmpty()) {
            Source source;
            Item item = dustStack.getItem();
            if (item instanceof EssenceItem) {
                EssenceItem essence = (EssenceItem)item;
                source = essence.getSource();
            } else {
                source = null;
            }
            itemStack = ManaOrbItem.attuneStorage(orbStack, source);
        } else {
            itemStack = ItemStack.EMPTY;
        }
        return itemStack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeSerializersPM.ATTUNE_MANA_ORB.get();
    }
}

