/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.verdantartifice.primalmagick.common.crafting.FakeInventory;
import com.verdantartifice.primalmagick.common.crafting.IWandTransform;
import com.verdantartifice.primalmagick.common.misc.BlockSwapper;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractWandTransform
implements IWandTransform {
    protected final ItemStack result;
    protected final AbstractRequirement<?> requirement;
    protected final Map<Block, MutableComponent> similarBlocks = new HashMap<Block, MutableComponent>();
    protected final Map<TagKey<Block>, MutableComponent> similarTags = new HashMap<TagKey<Block>, MutableComponent>();

    public AbstractWandTransform(@Nonnull ItemStack result, @Nullable AbstractRequirement<?> requirement) {
        this.result = result;
        this.requirement = requirement;
    }

    @Override
    public boolean isValid(Level world, Player player, BlockPos pos) {
        return this.requirement == null || this.requirement.isMetBy(player);
    }

    public void addSimilar(Block block, MutableComponent component) {
        this.similarBlocks.put(block, component);
    }

    public void addSimilar(TagKey<Block> tag, MutableComponent component) {
        this.similarTags.put(tag, component);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isSimilar(Level world, Player player, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        if (this.similarBlocks.keySet().stream().anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) return true;
        if (!this.similarTags.keySet().stream().anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) return false;
        return true;
    }

    @Override
    public void showSimilarityWarning(Level world, Player player, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        MutableComponent toShow = this.similarBlocks.get(state.getBlock());
        if (toShow == null) {
            toShow = this.similarTags.entrySet().stream().filter(entry -> state.is((TagKey)entry.getKey())).findFirst().map(Map.Entry::getValue).orElse(null);
        }
        if (toShow != null) {
            player.sendSystemMessage((Component)toShow.withStyle(ChatFormatting.RED));
        }
    }

    @Override
    public void execute(Level world, Player player, BlockPos pos) {
        Services.EVENTS.firePlayerCraftingEvent(player, this.result, (Container)new FakeInventory(1));
        BlockState state = world.getBlockState(pos);
        BlockSwapper.enqueue(world, new BlockSwapper(pos, state, this.result, player));
    }
}

