/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.crafting;

import com.verdantartifice.primalmagick.common.crafting.AbstractRecipe;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;

public abstract class AbstractTagCraftingRecipe<T extends RecipeInput>
extends AbstractRecipe<T> {
    protected final TagKey<Item> outputTag;
    protected final int outputAmount;

    protected AbstractTagCraftingRecipe(String group, TagKey<Item> outputTag, int outputAmount) {
        super(group);
        this.outputTag = outputTag;
        this.outputAmount = outputAmount;
    }

    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return this.getResultItemFromTag(pRegistries);
    }

    protected ItemStack getResultItemFromTag(HolderLookup.Provider pRegistries) {
        Optional tagOpt = pRegistries.lookupOrThrow(Registries.ITEM).get(this.outputTag);
        Optional modItemOpt = tagOpt.flatMap(tag -> tag.stream().filter(h -> h.is(key -> key.location().getNamespace().equals("primalmagick"))).findFirst());
        if (modItemOpt.isPresent()) {
            return new ItemStack((ItemLike)((Holder)modItemOpt.get()).value(), this.outputAmount);
        }
        Optional fallbackItemOpt = tagOpt.flatMap(tag -> tag.stream().findFirst());
        if (fallbackItemOpt.isPresent()) {
            return new ItemStack((ItemLike)((Holder)fallbackItemOpt.get()).value(), this.outputAmount);
        }
        return ItemStack.EMPTY;
    }
}

