/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.concoctions;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public enum FuseType implements StringRepresentable
{
    IMPACT(0, -1, "impact"),
    SHORT(1, 20, "short"),
    MEDIUM(2, 60, "medium"),
    LONG(3, 100, "long");

    private static final IntFunction<FuseType> BY_ID;
    public static final Codec<FuseType> CODEC;
    public static final StreamCodec<ByteBuf, FuseType> STREAM_CODEC;
    private final int id;
    private final int fuseLength;
    private final String tag;

    private FuseType(int id, int fuseLength, String tag) {
        this.id = id;
        this.fuseLength = fuseLength;
        this.tag = tag;
    }

    public int getId() {
        return this.id;
    }

    public int getFuseLength() {
        return this.fuseLength;
    }

    public String getSerializedName() {
        return this.tag;
    }

    public boolean hasTimer() {
        return this.fuseLength > 0;
    }

    @Nullable
    public FuseType getNext() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> SHORT;
            case 1 -> MEDIUM;
            case 2 -> LONG;
            case 3 -> IMPACT;
        };
    }

    public String getTranslationKey() {
        return "concoctions.primalmagick.fuse." + this.tag;
    }

    @Nullable
    public static FuseType fromName(@Nullable String name) {
        for (FuseType type : FuseType.values()) {
            if (!type.getSerializedName().equals(name)) continue;
            return type;
        }
        return null;
    }

    static {
        BY_ID = ByIdMap.continuous(FuseType::getId, (Object[])FuseType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        CODEC = StringRepresentable.fromValues(FuseType::values);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, FuseType::getId);
    }
}

