/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.concoctions;

import com.verdantartifice.primalmagick.common.components.DataComponentsPM;
import com.verdantartifice.primalmagick.common.concoctions.ConcoctionType;
import com.verdantartifice.primalmagick.common.concoctions.FuseType;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;

public class ConcoctionUtils {
    public static ItemStack newConcoction(Holder<Potion> potion, ConcoctionType type) {
        return ConcoctionUtils.setConcoctionType(PotionContents.createItemStack((Item)ItemsPM.CONCOCTION.get(), potion), type);
    }

    public static ItemStack newBomb(Holder<Potion> potion) {
        return ConcoctionUtils.newBomb(potion, FuseType.MEDIUM);
    }

    public static ItemStack newBomb(Holder<Potion> potion, FuseType fuse) {
        return ConcoctionUtils.setFuseType(ConcoctionUtils.setConcoctionType(PotionContents.createItemStack((Item)ItemsPM.ALCHEMICAL_BOMB.get(), potion), ConcoctionType.BOMB), fuse);
    }

    @Nonnull
    public static ConcoctionType getConcoctionType(@Nonnull ItemStack stack) {
        return (ConcoctionType)((Object)stack.getOrDefault(DataComponentsPM.CONCOCTION_TYPE.get(), (Object)ConcoctionType.WATER));
    }

    @Nonnull
    public static ItemStack setConcoctionType(@Nonnull ItemStack stack, @Nullable ConcoctionType concoctionType) {
        if (concoctionType != null) {
            stack.set(DataComponentsPM.CONCOCTION_TYPE.get(), (Object)concoctionType);
            ConcoctionUtils.setCurrentDoses(stack, concoctionType.getMaxDoses());
        }
        return stack;
    }

    public static int getCurrentDoses(@Nonnull ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponentsPM.CONCOCTION_DOSES.get(), (Object)0);
    }

    @Nonnull
    public static ItemStack setCurrentDoses(@Nonnull ItemStack stack, int doses) {
        ConcoctionType type;
        stack.set(DataComponentsPM.CONCOCTION_DOSES.get(), (Object)Math.min((type = ConcoctionUtils.getConcoctionType(stack)) == null ? 1 : type.getMaxDoses(), doses));
        return stack;
    }

    @Nullable
    public static FuseType getFuseType(@Nonnull ItemStack stack) {
        return (FuseType)((Object)stack.getOrDefault(DataComponentsPM.FUSE_TYPE.get(), (Object)FuseType.MEDIUM));
    }

    @Nonnull
    public static ItemStack setFuseType(@Nonnull ItemStack stack, @Nullable FuseType fuseType) {
        if (fuseType != null) {
            stack.set(DataComponentsPM.FUSE_TYPE.get(), (Object)fuseType);
        }
        return stack;
    }

    public static boolean hasBeneficialEffect(@Nonnull Potion potion) {
        for (MobEffectInstance instance : potion.getEffects()) {
            if (!((MobEffect)instance.getEffect().value()).isBeneficial()) continue;
            return true;
        }
        return false;
    }

    public static boolean isBomb(@Nonnull ItemStack stack) {
        return stack.getItem() == ItemsPM.ALCHEMICAL_BOMB.get();
    }
}

