/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SourceArgument
implements ArgumentType<ResourceLocation> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_SOURCE = new DynamicCommandExceptionType(p_308368_ -> Component.translatableEscape((String)"commands.primalmagick.source.noexist", (Object[])new Object[]{p_308368_}));

    public static SourceArgument source() {
        return new SourceArgument();
    }

    public static Source getSource(CommandContext<CommandSourceStack> pContext, String pName) throws CommandSyntaxException {
        ResourceLocation loc = SourceArgument.getId(pContext, pName);
        Source retVal = Sources.get(loc);
        if (retVal == null) {
            throw ERROR_UNKNOWN_SOURCE.create((Object)loc);
        }
        return retVal;
    }

    public static ResourceLocation getId(CommandContext<CommandSourceStack> pContext, String pName) {
        return (ResourceLocation)pContext.getArgument(pName, ResourceLocation.class);
    }

    public ResourceLocation parse(StringReader reader) throws CommandSyntaxException {
        return ResourceLocation.read((StringReader)reader);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining();
        Sources.stream().map(s -> s.getId()).filter(k -> k.toString().startsWith(remaining)).forEach(k -> builder.suggest(k.toString()));
        return builder.buildFuture();
    }
}

