/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.verdantartifice.primalmagick.common.affinities.AffinityManager;
import com.verdantartifice.primalmagick.common.affinities.IAffinity;
import com.verdantartifice.primalmagick.common.affinities.ItemAffinity;
import com.verdantartifice.primalmagick.common.attunements.AttunementManager;
import com.verdantartifice.primalmagick.common.attunements.AttunementType;
import com.verdantartifice.primalmagick.common.books.BookDefinition;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.BookLanguagesPM;
import com.verdantartifice.primalmagick.common.books.LinguisticsManager;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerArcaneRecipeBook;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.commands.arguments.AttunementTypeArgument;
import com.verdantartifice.primalmagick.common.commands.arguments.AttunementTypeInput;
import com.verdantartifice.primalmagick.common.commands.arguments.AttunementValueArgument;
import com.verdantartifice.primalmagick.common.commands.arguments.KnowledgeAmountArgument;
import com.verdantartifice.primalmagick.common.commands.arguments.KnowledgeTypeArgument;
import com.verdantartifice.primalmagick.common.commands.arguments.KnowledgeTypeInput;
import com.verdantartifice.primalmagick.common.commands.arguments.ResourceKeyArgumentPM;
import com.verdantartifice.primalmagick.common.commands.arguments.SourceArgument;
import com.verdantartifice.primalmagick.common.commands.arguments.StatValueArgument;
import com.verdantartifice.primalmagick.common.crafting.IArcaneRecipeBookItem;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBookManager;
import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.items.books.StaticBookItem;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.ResearchManager;
import com.verdantartifice.primalmagick.common.research.keys.AbstractResearchKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.common.stats.Stat;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.util.DataPackUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PrimalMagickCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        LiteralCommandNode node = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"primalmagick").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"reset").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(context -> PrimalMagickCommand.resetAll((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target")))))).then(Commands.literal((String)"research").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"list").executes(context -> PrimalMagickCommand.listResearch((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"))))).then(Commands.literal((String)"reset").executes(context -> PrimalMagickCommand.resetResearch((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"))))).then(Commands.literal((String)"grant_all").executes(context -> PrimalMagickCommand.grantAllResearch((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"))))).then(Commands.literal((String)"grant").then(Commands.argument((String)"research", ResourceKeyArgumentPM.key(RegistryKeysPM.RESEARCH_ENTRIES)).executes(context -> PrimalMagickCommand.grantResearch((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), ResourceKeyArgumentPM.getResearchEntry((CommandContext<CommandSourceStack>)context, "research")))))).then(Commands.literal((String)"grant_parents").then(Commands.argument((String)"research", ResourceKeyArgumentPM.key(RegistryKeysPM.RESEARCH_ENTRIES)).executes(context -> PrimalMagickCommand.grantResearchParents((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), ResourceKeyArgumentPM.getResearchEntry((CommandContext<CommandSourceStack>)context, "research")))))).then(Commands.literal((String)"revoke").then(Commands.argument((String)"research", ResourceKeyArgumentPM.key(RegistryKeysPM.RESEARCH_ENTRIES)).executes(context -> PrimalMagickCommand.revokeResearch((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), ResourceKeyArgumentPM.getResearchEntry((CommandContext<CommandSourceStack>)context, "research")))))).then(Commands.literal((String)"details").then(Commands.argument((String)"research", ResourceKeyArgumentPM.key(RegistryKeysPM.RESEARCH_ENTRIES)).executes(context -> PrimalMagickCommand.detailResearch((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), ResourceKeyArgumentPM.getResearchEntry((CommandContext<CommandSourceStack>)context, "research")))))).then(Commands.literal((String)"progress").then(Commands.argument((String)"research", ResourceKeyArgumentPM.key(RegistryKeysPM.RESEARCH_ENTRIES)).executes(context -> PrimalMagickCommand.progressResearch((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), ResourceKeyArgumentPM.getResearchEntry((CommandContext<CommandSourceStack>)context, "research")))))))).then(Commands.literal((String)"knowledge").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"reset").executes(context -> PrimalMagickCommand.resetKnowledge((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"))))).then(Commands.literal((String)"get").then(Commands.argument((String)"knowledge_type", (ArgumentType)KnowledgeTypeArgument.knowledgeType()).executes(context -> PrimalMagickCommand.getKnowledge((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), KnowledgeTypeArgument.getKnowledgeType(context, "knowledge_type")))))).then(Commands.literal((String)"add").then(Commands.argument((String)"knowledge_type", (ArgumentType)KnowledgeTypeArgument.knowledgeType()).then(Commands.argument((String)"points", (ArgumentType)KnowledgeAmountArgument.amount()).executes(context -> PrimalMagickCommand.addKnowledge((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), KnowledgeTypeArgument.getKnowledgeType(context, "knowledge_type"), IntegerArgumentType.getInteger((CommandContext)context, (String)"points"))))))))).then(Commands.literal((String)"scans").then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"grant").then(Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)buildContext)).executes(context -> PrimalMagickCommand.grantScanResearch((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), ItemArgument.getItem((CommandContext)context, (String)"item")))))).then(Commands.literal((String)"grant_all").executes(context -> PrimalMagickCommand.grantAllScanResearch((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"))))))).then(Commands.literal((String)"sources").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"list").executes(context -> PrimalMagickCommand.listUnlockedSources((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"))))).then(Commands.literal((String)"unlock_all").executes(context -> PrimalMagickCommand.unlockAllSources((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"))))).then(Commands.literal((String)"unlock").then(Commands.argument((String)"source", (ArgumentType)SourceArgument.source()).executes(context -> PrimalMagickCommand.unlockSource((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), SourceArgument.getSource((CommandContext<CommandSourceStack>)context, "source")))))))).then(Commands.literal((String)"stats").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"reset").executes(context -> PrimalMagickCommand.resetStats((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"))))).then(Commands.literal((String)"get").then(Commands.argument((String)"stat", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, sb) -> SharedSuggestionProvider.suggest(StatsManager.getStatLocations().stream().map(ResourceLocation::toString), (SuggestionsBuilder)sb)).executes(context -> PrimalMagickCommand.getStatValue((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), ResourceLocationArgument.getId((CommandContext)context, (String)"stat")))))).then(Commands.literal((String)"set").then(Commands.argument((String)"stat", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, sb) -> SharedSuggestionProvider.suggest(StatsManager.getStatLocations().stream().map(ResourceLocation::toString), (SuggestionsBuilder)sb)).then(Commands.argument((String)"value", (ArgumentType)StatValueArgument.value()).executes(context -> PrimalMagickCommand.setStatValue((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), ResourceLocationArgument.getId((CommandContext)context, (String)"stat"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value"))))))))).then(Commands.literal((String)"attunements").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"reset").executes(context -> PrimalMagickCommand.resetAttunements((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"))))).then(Commands.literal((String)"get").then(Commands.argument((String)"source", (ArgumentType)SourceArgument.source()).executes(context -> PrimalMagickCommand.getAttunements((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), SourceArgument.getSource((CommandContext<CommandSourceStack>)context, "source")))))).then(Commands.literal((String)"set").then(Commands.argument((String)"source", (ArgumentType)SourceArgument.source()).then(Commands.argument((String)"type", (ArgumentType)AttunementTypeArgument.attunementType()).then(Commands.argument((String)"value", (ArgumentType)AttunementValueArgument.value()).executes(context -> PrimalMagickCommand.setAttunement((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), SourceArgument.getSource((CommandContext<CommandSourceStack>)context, "source"), AttunementTypeArgument.getAttunementType(context, "type"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"affinities").then(((LiteralArgumentBuilder)Commands.literal((String)"lint").executes(context -> PrimalMagickCommand.getSourcelessItems((CommandSourceStack)context.getSource(), Arrays.asList("minecraft", "assets/primalmagick")))).then(Commands.literal((String)"all").executes(context -> PrimalMagickCommand.getSourcelessItems((CommandSourceStack)context.getSource(), null))))).then(((LiteralArgumentBuilder)Commands.literal((String)"generateDatapack").executes(context -> PrimalMagickCommand.writeSourcelessItemDatapack((CommandSourceStack)context.getSource(), Arrays.asList("minecraft", "assets/primalmagick")))).then(Commands.literal((String)"all").executes(context -> PrimalMagickCommand.writeSourcelessItemDatapack((CommandSourceStack)context.getSource(), null))))).then(Commands.literal((String)"explain").then(Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)buildContext)).executes(context -> PrimalMagickCommand.explainItemAffinity((CommandSourceStack)context.getSource(), ItemArgument.getItem((CommandContext)context, (String)"item"))))))).then(Commands.literal((String)"recipes").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"reset").executes(context -> PrimalMagickCommand.resetRecipes((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"))))).then(Commands.literal((String)"list").executes(context -> PrimalMagickCommand.listArcaneRecipes((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"))))).then(Commands.literal((String)"sync").executes(context -> PrimalMagickCommand.syncArcaneRecipes((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"))))).then(Commands.literal((String)"add").then(Commands.argument((String)"recipe", (ArgumentType)ResourceLocationArgument.id()).suggests(SuggestionProviders.ALL_RECIPES).executes(context -> PrimalMagickCommand.addArcaneRecipe((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), ResourceLocationArgument.getRecipe((CommandContext)context, (String)"recipe")))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"recipe", (ArgumentType)ResourceLocationArgument.id()).suggests(SuggestionProviders.ALL_RECIPES).executes(context -> PrimalMagickCommand.removeArcaneRecipe((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), ResourceLocationArgument.getRecipe((CommandContext)context, (String)"recipe")))))))).then(Commands.literal((String)"books").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"give").then(((RequiredArgumentBuilder)Commands.argument((String)"bookId", ResourceKeyArgumentPM.key(RegistryKeysPM.BOOKS)).executes(context -> PrimalMagickCommand.giveBook((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), ResourceKeyArgumentPM.getBook((CommandContext<CommandSourceStack>)context, "bookId"), PrimalMagickCommand.defaultLanguage((CommandSourceStack)context.getSource()), Optional.empty()))).then(((RequiredArgumentBuilder)Commands.argument((String)"languageId", ResourceKeyArgumentPM.key(RegistryKeysPM.BOOK_LANGUAGES)).executes(context -> PrimalMagickCommand.giveBook((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), ResourceKeyArgumentPM.getBook((CommandContext<CommandSourceStack>)context, "bookId"), ResourceKeyArgumentPM.getLanguage((CommandContext<CommandSourceStack>)context, "languageId"), Optional.empty()))).then(Commands.argument((String)"comprehension", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> PrimalMagickCommand.giveBook((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext)context, (String)"targets"), ResourceKeyArgumentPM.getBook((CommandContext<CommandSourceStack>)context, "bookId"), ResourceKeyArgumentPM.getLanguage((CommandContext<CommandSourceStack>)context, "languageId"), Optional.of(IntegerArgumentType.getInteger((CommandContext)context, (String)"comprehension"))))))))))).then(Commands.literal((String)"linguistics").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.literal((String)"reset").executes(context -> PrimalMagickCommand.resetLinguistics((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"comprehension").then(Commands.literal((String)"get").then(Commands.argument((String)"languageId", ResourceKeyArgumentPM.key(RegistryKeysPM.BOOK_LANGUAGES)).executes(context -> PrimalMagickCommand.getLanguageComprehension((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), ResourceKeyArgumentPM.getLanguage((CommandContext<CommandSourceStack>)context, "languageId")))))).then(Commands.literal((String)"set").then(Commands.argument((String)"languageId", ResourceKeyArgumentPM.key(RegistryKeysPM.BOOK_LANGUAGES)).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> PrimalMagickCommand.setLanguageComprehension((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), ResourceKeyArgumentPM.getLanguage((CommandContext<CommandSourceStack>)context, "languageId"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"vocabulary").then(Commands.literal((String)"get").then(Commands.argument((String)"languageId", ResourceKeyArgumentPM.key(RegistryKeysPM.BOOK_LANGUAGES)).executes(context -> PrimalMagickCommand.getLanguageVocabulary((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), ResourceKeyArgumentPM.getLanguage((CommandContext<CommandSourceStack>)context, "languageId")))))).then(Commands.literal((String)"set").then(Commands.argument((String)"languageId", ResourceKeyArgumentPM.key(RegistryKeysPM.BOOK_LANGUAGES)).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> PrimalMagickCommand.setLanguageVocabulary((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), ResourceKeyArgumentPM.getLanguage((CommandContext<CommandSourceStack>)context, "languageId"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"study_count").then(Commands.literal((String)"get").then(Commands.argument((String)"bookId", ResourceKeyArgumentPM.key(RegistryKeysPM.BOOKS)).then(Commands.argument((String)"languageId", ResourceKeyArgumentPM.key(RegistryKeysPM.BOOK_LANGUAGES)).executes(context -> PrimalMagickCommand.getBookStudyCount((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), ResourceKeyArgumentPM.getBook((CommandContext<CommandSourceStack>)context, "bookId"), ResourceKeyArgumentPM.getLanguage((CommandContext<CommandSourceStack>)context, "languageId"))))))).then(Commands.literal((String)"set").then(Commands.argument((String)"bookId", ResourceKeyArgumentPM.key(RegistryKeysPM.BOOKS)).then(Commands.argument((String)"languageId", ResourceKeyArgumentPM.key(RegistryKeysPM.BOOK_LANGUAGES)).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> PrimalMagickCommand.setBookStudyCount((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"target"), ResourceKeyArgumentPM.getBook((CommandContext<CommandSourceStack>)context, "bookId"), ResourceKeyArgumentPM.getLanguage((CommandContext<CommandSourceStack>)context, "languageId"), IntegerArgumentType.getInteger((CommandContext)context, (String)"value")))))))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pm").requires(source -> source.hasPermission(2))).redirect((CommandNode)node));
    }

    private static int resetAll(CommandSourceStack source, ServerPlayer player) {
        PrimalMagickCommand.resetResearch(source, player);
        PrimalMagickCommand.resetKnowledge(source, player);
        PrimalMagickCommand.resetAttunements(source, player);
        PrimalMagickCommand.resetStats(source, player);
        PrimalMagickCommand.resetRecipes(source, player);
        PrimalMagickCommand.resetLinguistics(source, player);
        return 0;
    }

    private static int listResearch(CommandSourceStack source, ServerPlayer target) {
        IPlayerKnowledge knowledge = Services.CAPABILITIES.knowledge((Player)target).orElse(null);
        if (knowledge == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.error"));
        } else {
            Set<AbstractResearchKey<?>> researchSet = knowledge.getResearchSet();
            CharSequence[] researchList = (String[])researchSet.stream().map(k -> k.toString()).collect(Collectors.toSet()).toArray(String[]::new);
            String output = String.join((CharSequence)", ", researchList);
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.research.list", (Object[])new Object[]{target.getName(), output}), true);
        }
        return 0;
    }

    private static int resetResearch(CommandSourceStack source, ServerPlayer target) {
        IPlayerKnowledge knowledge = Services.CAPABILITIES.knowledge((Player)target).orElse(null);
        if (knowledge == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.error"));
        } else {
            knowledge.clearResearch();
            ResearchManager.scheduleSync((Player)target);
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.research.reset", (Object[])new Object[]{target.getName()}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.research.reset.target", (Object[])new Object[]{source.getTextName()}));
            }
        }
        return 0;
    }

    private static int grantResearch(CommandSourceStack source, ServerPlayer target, Holder.Reference<ResearchEntry> entryHolder) {
        IPlayerKnowledge knowledge = Services.CAPABILITIES.knowledge((Player)target).orElse(null);
        ResearchEntryKey entryKey = new ResearchEntryKey((ResourceKey<ResearchEntry>)entryHolder.key());
        if (knowledge == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.error"));
        } else {
            ResearchManager.forceGrantWithAllParents((Player)target, entryKey);
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.research.grant", (Object[])new Object[]{target.getName(), entryKey.toString()}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.research.grant.target", (Object[])new Object[]{source.getTextName(), entryKey.toString()}));
            }
        }
        return 0;
    }

    private static int grantResearchParents(CommandSourceStack source, ServerPlayer target, Holder.Reference<ResearchEntry> entryHolder) {
        IPlayerKnowledge knowledge = Services.CAPABILITIES.knowledge((Player)target).orElse(null);
        ResearchEntryKey entryKey = new ResearchEntryKey((ResourceKey<ResearchEntry>)entryHolder.key());
        if (knowledge == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.error"));
        } else {
            ResearchManager.forceGrantParentsOnly((Player)target, entryKey);
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.research.grant_parents", (Object[])new Object[]{target.getName(), entryKey.toString()}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.research.grant_parents.target", (Object[])new Object[]{source.getTextName(), entryKey.toString()}));
            }
        }
        return 0;
    }

    private static int grantAllResearch(CommandSourceStack source, ServerPlayer target) {
        IPlayerKnowledge knowledge = Services.CAPABILITIES.knowledge((Player)target).orElse(null);
        if (knowledge == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.error"));
        } else {
            ResearchManager.forceGrantAll((Player)target);
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.research.grant_all", (Object[])new Object[]{target.getName()}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.research.grant_all.target", (Object[])new Object[]{source.getTextName()}));
            }
        }
        return 0;
    }

    private static int revokeResearch(CommandSourceStack source, ServerPlayer target, Holder.Reference<ResearchEntry> entryHolder) {
        IPlayerKnowledge knowledge = Services.CAPABILITIES.knowledge((Player)target).orElse(null);
        ResearchEntryKey entryKey = new ResearchEntryKey((ResourceKey<ResearchEntry>)entryHolder.key());
        if (knowledge == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.error"));
        } else {
            ResearchManager.forceRevokeWithAllChildren((Player)target, entryKey);
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.research.revoke", (Object[])new Object[]{target.getName(), entryKey.toString()}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.research.revoke.target", (Object[])new Object[]{source.getTextName(), entryKey.toString()}));
            }
        }
        return 0;
    }

    private static int detailResearch(CommandSourceStack source, ServerPlayer target, Holder.Reference<ResearchEntry> entryHolder) {
        IPlayerKnowledge knowledge = Services.CAPABILITIES.knowledge((Player)target).orElse(null);
        ResearchEntryKey entryKey = new ResearchEntryKey((ResourceKey<ResearchEntry>)entryHolder.key());
        if (knowledge == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.error"));
        } else {
            IPlayerKnowledge.ResearchStatus status = knowledge.getResearchStatus(source.registryAccess(), entryKey);
            int stage = knowledge.getResearchStage(entryKey);
            Set<IPlayerKnowledge.ResearchFlag> flagSet = knowledge.getResearchFlags(entryKey);
            CharSequence[] flagStrs = (String[])flagSet.stream().map(f -> f.name()).collect(Collectors.toSet()).toArray(String[]::new);
            String flagOutput = flagStrs.length == 0 ? "none" : String.join((CharSequence)", ", flagStrs);
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.research.details.1", (Object[])new Object[]{entryKey.toString(), target.getName()}), true);
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.research.details.2", (Object[])new Object[]{status.name()}), true);
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.research.details.3", (Object[])new Object[]{stage}), true);
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.research.details.4", (Object[])new Object[]{flagOutput}), true);
        }
        return 0;
    }

    private static int progressResearch(CommandSourceStack source, ServerPlayer target, Holder.Reference<ResearchEntry> entryHolder) {
        IPlayerKnowledge knowledge = Services.CAPABILITIES.knowledge((Player)target).orElse(null);
        ResearchEntryKey entryKey = new ResearchEntryKey((ResourceKey<ResearchEntry>)entryHolder.key());
        if (knowledge == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.error"));
        } else {
            int oldStage = knowledge.getResearchStage(entryKey);
            if (ResearchManager.progressResearch((Player)target, entryKey)) {
                int newStage = knowledge.getResearchStage(entryKey);
                source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.research.progress.success", (Object[])new Object[]{entryKey.toString(), target.getName(), oldStage, newStage}), true);
                if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                    target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.research.progress.target", (Object[])new Object[]{entryKey.toString(), source.getTextName(), oldStage, newStage}));
                }
            } else {
                source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.research.progress.failure", (Object[])new Object[]{entryKey.toString(), oldStage}), true);
            }
        }
        return 0;
    }

    private static int resetKnowledge(CommandSourceStack source, ServerPlayer target) {
        IPlayerKnowledge knowledge = Services.CAPABILITIES.knowledge((Player)target).orElse(null);
        if (knowledge == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.error"));
        } else {
            knowledge.clearKnowledge();
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.knowledge.reset", (Object[])new Object[]{target.getName()}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.knowledge.reset.target", (Object[])new Object[]{source.getTextName()}));
            }
        }
        return 0;
    }

    private static int getKnowledge(CommandSourceStack source, ServerPlayer target, KnowledgeTypeInput knowledgeTypeInput) {
        IPlayerKnowledge knowledge = Services.CAPABILITIES.knowledge((Player)target).orElse(null);
        KnowledgeType type = knowledgeTypeInput.getType();
        if (knowledge == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.error"));
        } else if (type == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.knowledge_type.noexist"));
        } else {
            int levels = knowledge.getKnowledge(type);
            int points = knowledge.getKnowledgeRaw(type);
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.knowledge.get", (Object[])new Object[]{target.getName(), levels, type.name(), points}), true);
        }
        return 0;
    }

    private static int addKnowledge(CommandSourceStack source, ServerPlayer target, KnowledgeTypeInput knowledgeTypeInput, int points) {
        IPlayerKnowledge knowledge = Services.CAPABILITIES.knowledge((Player)target).orElse(null);
        KnowledgeType type = knowledgeTypeInput.getType();
        if (knowledge == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.error"));
        } else if (type == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.knowledge_type.noexist"));
        } else if (ResearchManager.addKnowledge((Player)target, type, points)) {
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.knowledge.add.success", (Object[])new Object[]{points, type.name(), target.getName()}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.knowledge.add.target", (Object[])new Object[]{points, type.name(), source.getTextName()}));
            }
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.knowledge.add.failure", (Object[])new Object[]{target.getName()}), true);
        }
        return 0;
    }

    private static int grantScanResearch(CommandSourceStack source, ServerPlayer target, ItemInput item) {
        ItemStack stack;
        try {
            stack = item.createItemStack(1, false);
        }
        catch (CommandSyntaxException e) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.scans.grant.failure", (Object[])new Object[]{target.getName()}));
            return 0;
        }
        if (ResearchManager.setScanned(stack, target)) {
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.scans.grant.success", (Object[])new Object[]{target.getName(), Services.ITEMS_REGISTRY.getKey(item.getItem()).toString()}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.scans.grant.target", (Object[])new Object[]{source.getTextName(), Services.ITEMS_REGISTRY.getKey(item.getItem()).toString()}));
            }
        } else {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.scans.grant.failure", (Object[])new Object[]{target.getName()}));
        }
        return 0;
    }

    private static int grantAllScanResearch(CommandSourceStack source, ServerPlayer target) {
        int count = ResearchManager.setAllScanned(target);
        source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.scans.grant_all", (Object[])new Object[]{count, target.getName()}), true);
        if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
            target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.scans.grant_all.target", (Object[])new Object[]{count, source.getTextName()}));
        }
        return 0;
    }

    private static int listUnlockedSources(CommandSourceStack source, ServerPlayer target) {
        List<String> unlockedTags = Sources.streamSorted().filter(s -> s.isDiscovered((Player)target)).map(s -> s.getId().getPath().toUpperCase()).toList();
        String tagStr = String.join((CharSequence)", ", unlockedTags);
        source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.sources.list", (Object[])new Object[]{target.getName(), tagStr}), true);
        return 0;
    }

    private static int unlockAllSources(CommandSourceStack source, ServerPlayer target) {
        MutableInt unlocked = new MutableInt(0);
        Sources.stream().filter(s -> !s.isDiscovered((Player)target) && s.getDiscoverKey().isPresent()).map(s -> s.getDiscoverKey().get()).forEach(toUnlock -> {
            if (ResearchManager.completeResearch((Player)target, toUnlock)) {
                unlocked.increment();
            }
        });
        int totalUnlocked = unlocked.getValue();
        source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.sources.unlock_all", (Object[])new Object[]{target.getName(), totalUnlocked}), true);
        if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
            target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.sources.unlock_all.target", (Object[])new Object[]{source.getTextName(), totalUnlocked}));
        }
        return 0;
    }

    private static int unlockSource(CommandSourceStack source, ServerPlayer target, Source toUnlock) {
        if (toUnlock.isDiscovered((Player)target)) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.sources.unlock.already_unlocked", (Object[])new Object[]{target.getName(), toUnlock.getId().toString()}));
        } else if (toUnlock.getDiscoverKey().isPresent() && ResearchManager.completeResearch((Player)target, toUnlock.getDiscoverKey().get())) {
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.sources.unlock.success", (Object[])new Object[]{target.getName(), toUnlock.getId().toString()}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.sources.unlock.target", (Object[])new Object[]{source.getTextName(), toUnlock.getId().toString()}));
            }
        } else {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.sources.unlock.failure", (Object[])new Object[]{target.getName(), toUnlock.getId().toString()}));
        }
        return 0;
    }

    private static int getStatValue(CommandSourceStack source, ServerPlayer target, ResourceLocation statLoc) {
        Stat stat = StatsManager.getStat(statLoc);
        if (stat == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.stats.noexist", (Object[])new Object[]{statLoc}));
        } else {
            MutableComponent statName = Component.translatable((String)stat.getTranslationKey());
            Component statValue = StatsManager.getFormattedValue((Player)target, stat);
            source.sendSuccess(() -> PrimalMagickCommand.lambda$getStatValue$77(target, (Component)statName, statValue), true);
        }
        return 0;
    }

    private static int setStatValue(CommandSourceStack source, ServerPlayer target, ResourceLocation statLoc, int value) {
        Stat stat = StatsManager.getStat(statLoc);
        if (stat == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.stats.noexist", (Object[])new Object[]{statLoc}));
        } else {
            StatsManager.setValue((Player)target, stat, value);
            MutableComponent statName = Component.translatable((String)stat.getTranslationKey());
            Component statValue = StatsManager.getFormattedValue((Player)target, stat);
            source.sendSuccess(() -> PrimalMagickCommand.lambda$setStatValue$78(target, (Component)statName, statValue), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.stats.set.target", (Object[])new Object[]{source.getTextName(), statName, statValue}));
            }
        }
        return 0;
    }

    private static int resetStats(CommandSourceStack source, ServerPlayer target) {
        Services.CAPABILITIES.stats((Player)target).ifPresentOrElse(stats -> {
            stats.clear();
            StatsManager.scheduleSync((Player)target);
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.stats.reset", (Object[])new Object[]{target.getName()}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.stats.reset.target", (Object[])new Object[]{source.getTextName()}));
            }
        }, () -> source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.error")));
        return 0;
    }

    private static int resetAttunements(CommandSourceStack source, ServerPlayer target) {
        Services.CAPABILITIES.attunements((Player)target).ifPresentOrElse(attunements -> {
            attunements.clear();
            AttunementManager.removeAllAttributeModifiers((Player)target);
            AttunementManager.scheduleSync((Player)target);
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.attunements.reset", (Object[])new Object[]{target.getName()}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.attunements.reset.target", (Object[])new Object[]{source.getTextName()}));
            }
        }, () -> source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.error")));
        return 0;
    }

    private static int getAttunements(CommandSourceStack source, ServerPlayer target, Source toQuery) {
        MutableComponent sourceText = Component.translatable((String)toQuery.getNameTranslationKey());
        source.sendSuccess(() -> PrimalMagickCommand.lambda$getAttunements$85((Component)sourceText, source, target, toQuery), true);
        for (AttunementType type : AttunementType.values()) {
            MutableComponent typeText = Component.translatable((String)type.getNameTranslationKey());
            source.sendSuccess(() -> PrimalMagickCommand.lambda$getAttunements$86((Component)typeText, target, toQuery, type), true);
        }
        return 0;
    }

    private static int setAttunement(CommandSourceStack source, ServerPlayer target, Source toSet, AttunementTypeInput attunementType, int value) {
        AttunementType type = attunementType.getType();
        if (type == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.attunement_type.noexist"));
        } else {
            AttunementManager.setAttunement((Player)target, toSet, type, value);
            MutableComponent sourceText = Component.translatable((String)toSet.getNameTranslationKey());
            MutableComponent typeText = Component.translatable((String)type.getNameTranslationKey());
            if (type.isCapped() && value > type.getMaximum()) {
                source.sendSuccess(() -> PrimalMagickCommand.lambda$setAttunement$87(target, (Component)typeText, (Component)sourceText, type, value), true);
                if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                    target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.attunements.set.target.capped", (Object[])new Object[]{target.getName(), typeText, sourceText, type.getMaximum(), value}));
                }
            } else {
                source.sendSuccess(() -> PrimalMagickCommand.lambda$setAttunement$88(target, (Component)typeText, (Component)sourceText, value), true);
                if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                    target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.attunements.set.target", (Object[])new Object[]{target.getName(), typeText, sourceText, value}));
                }
            }
        }
        return 0;
    }

    private static int getSourcelessItems(CommandSourceStack source, Collection<String> excludeNamespaces) {
        ServerPlayer target = source.getPlayer();
        Logger LOGGER = LogManager.getLogger();
        ServerLevel level = source.getLevel();
        RecipeManager recipeManager = source.getLevel().getRecipeManager();
        RegistryAccess registryAccess = source.registryAccess();
        List<Item> sourcelessItems = PrimalMagickCommand.listSourcelessItems(recipeManager, registryAccess, level, excludeNamespaces);
        Object excludeNote = "";
        if (excludeNamespaces != null && excludeNamespaces.size() > 0) {
            excludeNote = " excluding resource namespaces: " + String.join((CharSequence)", ", excludeNamespaces);
        }
        target.sendSystemMessage((Component)Component.literal((String)("Found " + Integer.toString(sourcelessItems.size()) + " items without sources" + (String)excludeNote + "; check system logs for details")), false);
        LOGGER.info("Items with no sources: " + sourcelessItems.stream().map(Services.ITEMS_REGISTRY::getKey).toList().toString());
        return 0;
    }

    private static int writeSourcelessItemDatapack(CommandSourceStack source, Collection<String> excludeNamespaces) {
        Logger LOGGER = LogManager.getLogger();
        ServerPlayer target = source.getPlayer();
        ServerLevel level = source.getLevel();
        RecipeManager recipeManager = source.getLevel().getRecipeManager();
        RegistryAccess registryAccess = source.registryAccess();
        target.sendSystemMessage((Component)Component.literal((String)"Starting datapack template generation; this may take a while."));
        CompletableFuture.runAsync(() -> {
            byte[] itemsToDataPackTemplate;
            List<Item> sourcelessItems = PrimalMagickCommand.listSourcelessItems(recipeManager, registryAccess, level, excludeNamespaces);
            List<EntityType<?>> sourcelessEntities = PrimalMagickCommand.listSourcelessEntityTypes(registryAccess, excludeNamespaces);
            try {
                itemsToDataPackTemplate = DataPackUtils.ItemsToDataPackTemplate(sourcelessItems, sourcelessEntities);
            }
            catch (IOException e) {
                LOGGER.atError().withThrowable((Throwable)e).log("Unable to generate datapack");
                target.sendSystemMessage((Component)Component.literal((String)"Failed to write datapack template"));
                return;
            }
            try {
                File tempFile = File.createTempFile("primalMagickDataPack", ".zip");
                String filePath = tempFile.getAbsolutePath();
                FileOutputStream fos = new FileOutputStream(tempFile);
                fos.write(itemsToDataPackTemplate);
                fos.close();
                target.sendSystemMessage((Component)Component.literal((String)"Wrote datapack template for sourceless items and entities to disk; check system logs for location."));
                LOGGER.atInfo().log("Wrote datapack to {}", (Object)filePath);
            }
            catch (IOException e) {
                LOGGER.atError().withThrowable((Throwable)e).log("Unable to write datapack");
                target.sendSystemMessage((Component)Component.literal((String)"Failed to write datapack template"));
            }
        }, Util.backgroundExecutor()).exceptionally(e -> {
            LOGGER.error("Unable to write datapack", e);
            target.sendSystemMessage((Component)Component.literal((String)"Failed to write datapack template"));
            return null;
        });
        return 0;
    }

    private static List<EntityType<?>> listSourcelessEntityTypes(RegistryAccess registryAccess, Collection<String> excludeNamespaces) {
        AffinityManager am = AffinityManager.getOrCreateInstance();
        Vector retVal = new Vector();
        Services.ENTITY_TYPES_REGISTRY.getAll().forEach(entityType -> {
            ResourceLocation resourceLocation = Services.ENTITY_TYPES_REGISTRY.getKey(entityType);
            if (resourceLocation == null) {
                return;
            }
            String namespace = resourceLocation.getNamespace();
            if (excludeNamespaces != null && excludeNamespaces.contains(namespace)) {
                return;
            }
            CompletableFuture<SourceList> future = am.getAffinityValuesAsync((EntityType<?>)entityType, registryAccess);
            try {
                SourceList sources = future.get();
                if (sources.isEmpty()) {
                    retVal.add((EntityType<?>)entityType);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        });
        return retVal;
    }

    private static List<Item> listSourcelessItems(RecipeManager recipeManager, RegistryAccess registryAccess, ServerLevel level, Collection<String> excludeNamespaces) {
        AffinityManager am = AffinityManager.getOrCreateInstance();
        Vector<Item> items = new Vector<Item>();
        Services.ITEMS_REGISTRY.getAll().forEach(item -> {
            SourceList sources;
            ResourceLocation itemId = Services.ITEMS_REGISTRY.getKey(item);
            if (itemId == null) {
                return;
            }
            String namespace = itemId.getNamespace();
            if (excludeNamespaces != null && excludeNamespaces.contains(namespace)) {
                return;
            }
            IAffinity affinityData = am.getOrGenerateItemAffinityAsync(itemId, recipeManager, registryAccess, new ArrayList<ResourceLocation>()).join();
            if (PrimalMagickCommand.getRecipeCountForItem(recipeManager, registryAccess, item) == 0L && (sources = affinityData.getTotalAsync(recipeManager, registryAccess, new ArrayList<ResourceLocation>()).join()).isEmpty()) {
                items.add((Item)item);
            }
        });
        return items;
    }

    private static long getRecipeCountForItem(RecipeManager recipeManager, RegistryAccess registryAccess, Item item) {
        long count = recipeManager.getRecipes().stream().map(RecipeHolder::value).filter(r -> r.getResultItem((HolderLookup.Provider)registryAccess) != null && r.getResultItem((HolderLookup.Provider)registryAccess).getItem().equals(item)).count();
        return count;
    }

    private static int resetRecipes(CommandSourceStack source, ServerPlayer target) {
        IPlayerArcaneRecipeBook recipeBook = Services.CAPABILITIES.arcaneRecipeBook((Player)target).orElse(null);
        if (recipeBook == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.error"));
        } else {
            recipeBook.get().clear();
            ArcaneRecipeBookManager.scheduleSync((Player)target);
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.recipes.reset", (Object[])new Object[]{target.getName()}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.recipes.reset.target", (Object[])new Object[]{source.getTextName()}));
            }
        }
        return 0;
    }

    private static int listArcaneRecipes(CommandSourceStack source, ServerPlayer target) {
        IPlayerArcaneRecipeBook recipeBook = Services.CAPABILITIES.arcaneRecipeBook((Player)target).orElse(null);
        if (recipeBook == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.error"));
        } else {
            Set<ResourceLocation> knownSet = recipeBook.get().getKnown();
            CharSequence[] knownList = knownSet.stream().map(r -> r.toString()).collect(Collectors.toSet()).toArray(new String[knownSet.size()]);
            String knownOutput = String.join((CharSequence)", ", knownList);
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.recipes.list.known", (Object[])new Object[]{target.getName(), knownOutput}), true);
            Set<ResourceLocation> highlightSet = recipeBook.get().getHighlight();
            CharSequence[] highlightList = highlightSet.stream().map(r -> r.toString()).collect(Collectors.toSet()).toArray(new String[highlightSet.size()]);
            String highlightOutput = String.join((CharSequence)", ", highlightList);
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.recipes.list.highlight", (Object[])new Object[]{target.getName(), highlightOutput}), true);
        }
        return 0;
    }

    private static int syncArcaneRecipes(CommandSourceStack source, ServerPlayer target) {
        if (!ArcaneRecipeBookManager.syncRecipesWithResearch(target)) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.error"));
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.recipes.sync", (Object[])new Object[]{target.getName()}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.recipes.sync.target", (Object[])new Object[]{source.getTextName()}));
            }
        }
        return 0;
    }

    private static int addArcaneRecipe(CommandSourceStack source, ServerPlayer target, RecipeHolder<?> recipe) {
        IPlayerArcaneRecipeBook recipeBook = Services.CAPABILITIES.arcaneRecipeBook((Player)target).orElse(null);
        if (recipeBook == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.error"));
        } else if (!(recipe.value() instanceof IArcaneRecipeBookItem)) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.recipes.recipe_not_arcane"));
        } else {
            ArcaneRecipeBookManager.addRecipes(Collections.singletonList(recipe), target);
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.recipes.add", (Object[])new Object[]{target.getName(), recipe.id().toString()}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.recipes.add.target", (Object[])new Object[]{source.getTextName(), recipe.id().toString()}));
            }
        }
        return 0;
    }

    private static int removeArcaneRecipe(CommandSourceStack source, ServerPlayer target, RecipeHolder<?> recipe) {
        IPlayerArcaneRecipeBook recipeBook = Services.CAPABILITIES.arcaneRecipeBook((Player)target).orElse(null);
        if (recipeBook == null) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.error"));
        } else if (!(recipe.value() instanceof IArcaneRecipeBookItem)) {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.recipes.recipe_not_arcane"));
        } else {
            ArcaneRecipeBookManager.removeRecipes(Collections.singletonList(recipe), target);
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.recipes.remove", (Object[])new Object[]{target.getName(), recipe.id().toString()}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.recipes.remove.target", (Object[])new Object[]{source.getTextName(), recipe.id().toString()}));
            }
        }
        return 0;
    }

    private static Holder.Reference<BookLanguage> defaultLanguage(CommandSourceStack source) {
        return BookLanguagesPM.getLanguageOrThrow(BookLanguagesPM.DEFAULT, (RegistryAccess)source.getServer().registryAccess());
    }

    private static int giveBook(CommandSourceStack source, Collection<ServerPlayer> targets, Holder.Reference<BookDefinition> bookDef, Holder.Reference<BookLanguage> bookLanguage, Optional<Integer> comprehension) {
        ItemStack bookStack = new ItemStack((ItemLike)ItemsPM.STATIC_BOOK.get());
        StaticBookItem.setBookDefinition(bookStack, bookDef);
        StaticBookItem.setBookLanguage(bookStack, bookLanguage);
        StaticBookItem.setGeneration(bookStack, 0);
        StaticBookItem.setTranslatedComprehension(bookStack, comprehension);
        for (ServerPlayer serverPlayer : targets) {
            ItemEntity bookEntity;
            ItemStack bookCopy = bookStack.copy();
            if (serverPlayer.getInventory().add(bookCopy) || (bookEntity = serverPlayer.drop(bookCopy, false)) == null) continue;
            bookEntity.setNoPickUpDelay();
            bookEntity.setTarget(serverPlayer.getUUID());
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.give.success.single", (Object[])new Object[]{1, bookStack.getDisplayName(), ((ServerPlayer)targets.iterator().next()).getDisplayName()}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.give.success.multiple", (Object[])new Object[]{1, bookStack.getDisplayName(), targets.size()}), true);
        }
        return targets.size();
    }

    private static int resetLinguistics(CommandSourceStack source, ServerPlayer target) {
        Services.CAPABILITIES.linguistics((Player)target).ifPresentOrElse(linguistics -> {
            linguistics.clear();
            LinguisticsManager.scheduleSync((Player)target);
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.linguistics.reset", (Object[])new Object[]{target.getName()}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.linguistics.reset.target", (Object[])new Object[]{source.getTextName()}));
            }
        }, () -> source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.error")));
        return 0;
    }

    private static int getLanguageComprehension(CommandSourceStack source, ServerPlayer target, Holder.Reference<BookLanguage> bookLanguage) {
        source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.linguistics.comprehension.get", (Object[])new Object[]{target.getName(), bookLanguage.key().location(), LinguisticsManager.getComprehension((Player)target, (Holder<BookLanguage>)bookLanguage)}), true);
        return 0;
    }

    private static int setLanguageComprehension(CommandSourceStack source, ServerPlayer target, Holder.Reference<BookLanguage> bookLanguage, int value) {
        int complexity = ((BookLanguage)bookLanguage.value()).complexity();
        ResourceLocation langKey = bookLanguage.key().location();
        LinguisticsManager.setComprehension((Player)target, bookLanguage, value);
        int newValue = LinguisticsManager.getComprehension((Player)target, bookLanguage);
        if (value > complexity) {
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.linguistics.comprehension.set.success.capped", (Object[])new Object[]{target.getName(), langKey.toString(), complexity, newValue}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.linguistics.comprehension.set.target.capped", (Object[])new Object[]{source.getTextName(), langKey.toString(), complexity, newValue}));
            }
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.linguistics.comprehension.set.success", (Object[])new Object[]{target.getName(), langKey.toString(), newValue}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.linguistics.comprehension.set.target", (Object[])new Object[]{source.getTextName(), langKey.toString(), newValue}));
            }
        }
        return 0;
    }

    private static int getLanguageVocabulary(CommandSourceStack source, ServerPlayer target, Holder.Reference<BookLanguage> bookLanguage) {
        source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.linguistics.vocabulary.get", (Object[])new Object[]{target.getName(), bookLanguage.key().location(), LinguisticsManager.getVocabulary((Player)target, (Holder<BookLanguage>)bookLanguage)}), true);
        return 0;
    }

    private static int setLanguageVocabulary(CommandSourceStack source, ServerPlayer target, Holder.Reference<BookLanguage> bookLanguage, int value) {
        ResourceLocation langKey = bookLanguage.key().location();
        LinguisticsManager.setVocabulary((Player)target, bookLanguage, value);
        int newValue = LinguisticsManager.getVocabulary((Player)target, bookLanguage);
        source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.linguistics.vocabulary.set.success", (Object[])new Object[]{target.getName(), langKey.toString(), newValue}), true);
        if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
            target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.linguistics.vocabulary.set.target", (Object[])new Object[]{source.getTextName(), langKey.toString(), newValue}));
        }
        return 0;
    }

    private static int getBookStudyCount(CommandSourceStack source, ServerPlayer target, Holder.Reference<BookDefinition> bookDef, Holder.Reference<BookLanguage> bookLanguage) {
        source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.linguistics.study_count.get", (Object[])new Object[]{target.getName(), bookDef.key().location(), bookLanguage.key().location(), LinguisticsManager.getTimesStudied((Player)target, (Holder<BookDefinition>)bookDef, (Holder<BookLanguage>)bookLanguage)}), true);
        return 0;
    }

    private static int setBookStudyCount(CommandSourceStack source, ServerPlayer target, Holder.Reference<BookDefinition> bookDef, Holder.Reference<BookLanguage> bookLanguage, int value) {
        ResourceLocation bookId = bookDef.key().location();
        ResourceLocation langKey = bookLanguage.key().location();
        LinguisticsManager.setTimesStudied((Player)target, bookDef, bookLanguage, value);
        int newValue = LinguisticsManager.getTimesStudied((Player)target, bookDef, bookLanguage);
        if (value > 3) {
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.linguistics.study_count.set.success.capped", (Object[])new Object[]{target.getName(), bookId.toString(), langKey.toString(), newValue, value}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.linguistics.study_count.set.target.capped", (Object[])new Object[]{source.getTextName(), bookId.toString(), langKey.toString(), newValue, value}));
            }
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.linguistics.study_count.set.success", (Object[])new Object[]{target.getName(), bookId.toString(), langKey.toString(), newValue}), true);
            if (source.getPlayer() == null || source.getPlayer().getId() != target.getId()) {
                target.sendSystemMessage((Component)Component.translatable((String)"commands.primalmagick.linguistics.study_count.set.target", (Object[])new Object[]{source.getTextName(), bookId.toString(), langKey.toString(), newValue}));
            }
        }
        return 0;
    }

    private static int explainItemAffinity(CommandSourceStack source, ItemInput item) {
        ResourceLocation itemId = Services.ITEMS_REGISTRY.getKey(item.getItem());
        IAffinity affinityData = AffinityManager.getInstance().getOrGenerateItemAffinityAsync(itemId, source.getLevel().getRecipeManager(), source.registryAccess(), new ArrayList<ResourceLocation>()).join();
        if (affinityData instanceof ItemAffinity) {
            ItemAffinity itemAffinity = (ItemAffinity)affinityData;
            itemAffinity.getSourceRecipe().ifPresentOrElse(recipeLoc -> source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.affinities.explain.from_recipe", (Object[])new Object[]{itemId.toString(), recipeLoc.toString()}), true), () -> source.sendSuccess(() -> Component.translatable((String)"commands.primalmagick.affinities.explain.from_data", (Object[])new Object[]{itemId.toString()}), true));
        } else {
            source.sendFailure((Component)Component.translatable((String)"commands.primalmagick.affinities.explain.not_found", (Object[])new Object[]{itemId.toString()}));
        }
        return 0;
    }

    private static /* synthetic */ Component lambda$setAttunement$88(ServerPlayer target, Component typeText, Component sourceText, int value) {
        return Component.translatable((String)"commands.primalmagick.attunements.set.success", (Object[])new Object[]{target.getName(), typeText, sourceText, value});
    }

    private static /* synthetic */ Component lambda$setAttunement$87(ServerPlayer target, Component typeText, Component sourceText, AttunementType type, int value) {
        return Component.translatable((String)"commands.primalmagick.attunements.set.success.capped", (Object[])new Object[]{target.getName(), typeText, sourceText, type.getMaximum(), value});
    }

    private static /* synthetic */ Component lambda$getAttunements$86(Component typeText, ServerPlayer target, Source toQuery, AttunementType type) {
        return Component.translatable((String)"commands.primalmagick.attunements.get.partial", (Object[])new Object[]{typeText, AttunementManager.getAttunement((Player)target, toQuery, type)});
    }

    private static /* synthetic */ Component lambda$getAttunements$85(Component sourceText, CommandSourceStack source, ServerPlayer target, Source toQuery) {
        return Component.translatable((String)"commands.primalmagick.attunements.get.total", (Object[])new Object[]{sourceText, source.getTextName(), AttunementManager.getTotalAttunement((Player)target, toQuery)});
    }

    private static /* synthetic */ Component lambda$setStatValue$78(ServerPlayer target, Component statName, Component statValue) {
        return Component.translatable((String)"commands.primalmagick.stats.set", (Object[])new Object[]{target.getName(), statName, statValue});
    }

    private static /* synthetic */ Component lambda$getStatValue$77(ServerPlayer target, Component statName, Component statValue) {
        return Component.translatable((String)"commands.primalmagick.stats.get", (Object[])new Object[]{target.getName(), statName, statValue});
    }
}

