/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.mojang.serialization.DynamicOps;
import com.verdantartifice.primalmagick.common.capabilities.ITileResearchCache;
import com.verdantartifice.primalmagick.common.research.keys.AbstractResearchKey;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TileResearchCache
implements ITileResearchCache {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<AbstractResearchKey<?>> research = ConcurrentHashMap.newKeySet();

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag rootTag = new CompoundTag();
        ListTag researchList = new ListTag();
        this.research.forEach(k -> AbstractResearchKey.dispatchCodec().encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), k).resultOrPartial(msg -> LOGGER.error("Failed to encode research key in tile research cache capability: {}", msg)).ifPresent(encodedTag -> researchList.add(encodedTag)));
        rootTag.put("research", (Tag)researchList);
        return rootTag;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag nbt) {
        if (nbt == null) {
            return;
        }
        this.clear();
        ListTag researchList = nbt.getList("research", 10);
        for (int index = 0; index < researchList.size(); ++index) {
            CompoundTag innerTag = researchList.getCompound(index);
            AbstractResearchKey.dispatchCodec().parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)innerTag).resultOrPartial(msg -> LOGGER.error("Failed to decode research key in tile research cache capability: {}", msg)).ifPresent(parsedKey -> this.research.add((AbstractResearchKey<?>)parsedKey));
        }
    }

    @Override
    public void clear() {
        this.research.clear();
    }

    @Override
    public boolean isResearchComplete(AbstractResearchKey<?> key) {
        if (key == null) {
            return false;
        }
        return this.research.contains(key);
    }

    @Override
    public boolean isResearchComplete(List<AbstractResearchKey<?>> keys) {
        return keys.stream().allMatch(k -> this.isResearchComplete((AbstractResearchKey<?>)k));
    }

    @Override
    public void update(Player player, Predicate<AbstractResearchKey<?>> researchFilter) {
        Services.CAPABILITIES.knowledge(player).ifPresent(knowledge -> {
            this.clear();
            RegistryAccess registryAccess = player.level().registryAccess();
            for (AbstractResearchKey<?> key : knowledge.getResearchSet()) {
                if (!knowledge.isResearchComplete(registryAccess, key) || researchFilter != null && !researchFilter.test(key)) continue;
                this.research.add(key);
            }
        });
    }
}

